import time
from  com.ibm.ws.scripting import ScriptingException

#
# util
#
def webserverMBean(cellName, nodeName):
    webserverObjectName = AdminControl.completeObjectName('type=WebServer,cell=%s,*' % (cellName))
    if webserverObjectName == '':
        raise 'Unable to get object name of web server on cell %s and node %s. Is web server running?' % (cellName, nodeName)
    return webserverObjectName

def findWebServerId(nodeName, serverName):
    serverId = AdminConfig.getid('/Node:%s/Server:%s/' % (nodeName, serverName))
    return serverId

def getWebServerStatus(cellName, nodeName, serverName):
    webserverBeanName = webserverMBean(cellName, nodeName)
    webserverArgs = '%s %s %s' % (cellName, nodeName, serverName)
    return AdminControl.invoke(webserverBeanName, 'status', webserverArgs).upper()

def failIfWebServerNotRunning(cellName, nodeName, serverName):
    serverStatus = getWebServerStatus(cellName, nodeName, serverName)
    if serverStatus != 'RUNNING':
        print "ERROR: Web Server %s on %s:%s did not start immediately. Current status: %s." % (server.name, server.cellName,
                                                                                                server.nodeName, serverStatus)
        sys.exit(1)

def failIfWebServerNotStopped(cellName, nodeName, serverName):
    serverStatus = getWebServerStatus(cellName, nodeName, serverName)
    if serverStatus != 'STOPPED':
        print "ERROR: Web Server %s on %s:%s did not start immediately. Current status: %s." % (server.name, server.cellName,
                                                                                                server.nodeName, serverStatus)
        sys.exit(1)

def waitUntil(state, failure, cellName, nodeName, serverName, maxRetries, sleepTime):
    serverStatus = getWebServerStatus(cellName, nodeName, serverName)
    retry = 0
    while retry < maxRetries and not serverStatus == state:
        retry = retry + 1
        print "Attempt: %s. Web Server %s on %s:%s is: %s." % (retry, serverName, cellName, nodeName, serverStatus)
        time.sleep(sleepTime)
    serverStatus = getWebServerStatus(cellName, nodeName, serverName)
    if not serverStatus == state:
        raise failure
    else:
        print "INFO: Web server %s on %s:%s is: %s:%s." % (serverName, cellName, nodeName, serverStatus, state)
#
# start
#
def startImmediate(cellName, nodeName, serverName, maxRetries, sleepTime):
    retry = 0
    while retry < maxRetries:
        retry = retry + 1
        try:
            serverStatus = getWebServerStatus(cellName, nodeName, serverName)
            if 'RUNNING' != serverStatus and 'STARTING' != serverStatus:
                webserverMBeanName = webserverMBean(cellName, nodeName)
                webserverArgs = '%s %s %s' % (cellName, nodeName, serverName)
                AdminControl.invoke(webserverMBeanName, 'start', webserverArgs)
                waitUntil('RUNNING', 'Web server did not start in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName,
                          serverName, maxRetries, sleepTime)
        except:
            serverStatus = getWebServerStatus(cellName, nodeName, serverName)
            if 'RUNNING' == serverStatus:
                print "INFO: Web server %s on %s:%s is: %s." % (serverName, cellName, nodeName, serverStatus)
                break
            print "INFO: Web server %s on %s:%s did not start immediately. Current status: %s. Will wait %s seconds and try again." \
                  % (serverName, cellName, nodeName, serverStatus, sleepTime)
            time.sleep(sleepTime)

def startWebServer(cellName, nodeName, serverName, maxRetries, sleepTime):
    serverId = findWebServerId(nodeName, serverName)
    exitWithMessageIfEmpty(serverId, "ERROR: Web Server '%s' does not exist on node '%s'." % (serverName, nodeName), 1)
    serverStatus = getWebServerStatus(cellName, nodeName, serverName)
    if 'FAILED' == serverStatus:
        raise "ERROR: Server %s on %s:%s is %s." % (serverName, cellName, nodeName, serverStatus)
    elif 'RUNNING' == serverStatus:
        print "INFO: Server %s on %s:%s is %s. Nothing to do." % (serverName, cellName, nodeName, serverStatus)
    elif 'STARTING' == serverStatus:
        waitUntil('RUNNING', 'ERROR: Server not started in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName,
                  serverName, maxRetries, sleepTime)
    elif 'STOPPING' == serverStatus:
        waitUntil('STOPPED', 'ERROR: Server not started in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName,
                  serverName, maxRetries, sleepTime)
        startImmediate(cellName, nodeName, serverName, maxRetries, sleepTime)
    else:
        startImmediate(cellName, nodeName, serverName, maxRetries, sleepTime)

#
# stop
#
def stopImmediate(cellName, nodeName, serverName, maxRetries, sleepTime):
    retry = 0
    while retry < maxRetries:
        retry = retry + 1
        try:
            serverStatus = getWebServerStatus(cellName, nodeName, serverName)
            if 'STOPPED' != serverStatus and 'STOPPING' != serverStatus:
                webserverMBeanName = webserverMBean(cellName, nodeName)
                webserverArgs = '%s %s %s' % (cellName, nodeName, serverName)
                AdminControl.invoke(webserverMBeanName, 'stop', webserverArgs)
                waitUntil('STOPPED', 'Web server did not stop in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName,
                          serverName, maxRetries, sleepTime)
        except:
            serverStatus = getWebServerStatus(cellName, nodeName, serverName)
            if 'STOPPED' == serverStatus:
                print "INFO: Web server %s on %s:%s is: %s." % (serverName, cellName, nodeName, serverStatus)
                break
            print "INFO: Web server %s on %s:%s did not stop immediately. Current status: %s. Will wait %s seconds and try again." \
                  % (serverName, cellName, nodeName, serverStatus, sleepTime)
            time.sleep(sleepTime)

def stopWebServer(cellName, nodeName, serverName, maxRetries, sleepTime):
    serverId = findWebServerId(nodeName, serverName)
    exitWithMessageIfEmpty(serverId, "ERROR: Server '%s' does not exist on node '%s'." % (serverName, nodeName), 1)
    serverStatus = getWebServerStatus(cellName, nodeName, serverName)
    if 'FAILED' == serverStatus:
        raise "INFO: Web server %s on %s:%s is %s." % (serverName, cellName, nodeName, serverStatus)
    elif 'STOPPED' == serverStatus:
        print "INFO: Web server %s on %s:%s is %s." % (serverName, cellName, nodeName, serverStatus)
    elif 'STARTING' == serverStatus:
        waitUntil('RUNNING', 'ERROR: Web server not started in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName, serverName, maxRetries, sleepTime)
        stopImmediate(cellName, nodeName, serverName, maxRetries, sleepTime)
    elif 'STOPPING' == serverStatus:
        waitUntil('STOPPED', 'ERROR: Web server not started in %s seconds.' % (maxRetries * sleepTime), cellName, nodeName, serverName, maxRetries, sleepTime)
    else:
        stopImmediate(cellName, nodeName, serverName, maxRetries, sleepTime)

try:
    server = container
except NameError:
    server = deployed

stopWebServer(server.cellName, server.nodeName, server.name, server.maxRetries, server.sleepTime)
failIfWebServerNotStopped(server.cellName, server.nodeName, server.name)

startWebServer(server.cellName, server.nodeName, server.name, server.maxRetries, server.sleepTime)
failIfWebServerNotRunning(server.cellName, server.nodeName, server.name)


