import sys

def getServerPortMap(startPort, portOffset):
    portMap = {
        'BOOTSTRAP_ADDRESS': startPort,
        'SOAP_CONNECTOR_ADDRESS': startPort + (portOffset * 1),
        'SAS_SSL_SERVERAUTH_LISTENER_ADDRESS': startPort + (portOffset * 2),
        'CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS': startPort + (portOffset * 3),
        'CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS': startPort + (portOffset * 4),
        'WC_adminhost': startPort + (portOffset * 5),
        'WC_defaulthost': startPort + (portOffset * 6),
        'DCS_UNICAST_ADDRESS': startPort + (portOffset * 7),
        'WC_adminhost_secure': startPort + (portOffset * 8),
        'WC_defaulthost_secure': startPort + (portOffset * 9),
        'SIB_ENDPOINT_ADDRESS': startPort + (portOffset * 10),
        'SIB_MQ_ENDPOINT_SECURE_ADDRESS': startPort + (portOffset * 11),
        'SIB_MQ_ENDPOINT_ADDRESS': startPort + (portOffset * 12),
        'SIB_ENDPOINT_SECURE_ADDRESS': startPort + (portOffset * 13),
        'SIP_DEFAULTHOST': startPort + (portOffset * 14),
        'SIP_DEFAULTHOST_SECURE': startPort + (portOffset * 15),
        'ORB_LISTENER_ADDRESS': startPort + (portOffset * 16),
        'IPC_CONNECTOR_ADDRESS': startPort + (portOffset * 17),
        'OVERLAY_TCP_LISTENER_ADDRESS': startPort + (portOffset * 18),
        'OVERLAY_UDP_LISTENER_ADDRESS': startPort + (portOffset * 19)
    }
    return portMap

def modifyServerPorts(nodeName, serverName, startPort, portOffset):
    portMap = getServerPortMap(startPort, portOffset)

    for endpoint, port in portMap.items():
        args = ['-nodeName', nodeName, '-endPointName', endpoint, '-port', port, '-modifyShared', 'true']
        print "Modifying ports on server '%s' on node '%s': %s" % (serverName, nodeName, args)
        AdminTask.modifyServerPort (serverName, args)

def checkIfServerExists(nodeName, serverName):
    serverId = AdminConfig.getid('/Node:%s/Server:%s/' % (nodeName, serverName))
    if serverId == "":
        print "WARN: Server '%s' does not exist on node '%s'." % (serverName, nodeName)
        sys.exit(1)

try:
    server = container

except NameError:
    server = deployed

# ilx: do not create server if it should be part of a cluster?
checkIfServerExists(server.nodeName, server.name)
modifyServerPorts(server.nodeName, server.name, server.startPort, server.portOffset)
saveConfiguration()
syncNode(server.nodeName)

