def discoverAndInspectJaasAliasInContainer(container, jaasInspectCallback):
    securityId = AdminConfig.getid("/Cell:%s/Security:/" % (container.cellName))
    jaasAliases = wsadminToList(AdminConfig.list('JAASAuthData', securityId))
    for alias in jaasAliases:
        deployedName = AdminConfig.showAttribute(alias, 'alias')
        if deployedName.find('/') == -1:
            deployedId = container.id + '/' + deployedName
            if appendTypeToName:
                deployedId = deployedId + '_' + prototype.type

            discovered(deployedId, prototype.type)
            inspectedProperty(deployedId, 'wasName', deployedName)

            jaasInspectCallback(deployedId, deployedName, alias, container)
            inspectedItem(deployedId)
        else:
            print "WARN: Ignoring discovered JAAS alias '%s' that cannot be managed by Deployit (since it has a '/' in the name)" % (deployedName)

def discoverAndInspectJaasAlias(jaasInspectCallback=None):
    if jaasInspectCallback is None:
        jaasInspectCallback = inspectJaasAlias
    discoverAndInspectJaasAliasInContainer(container, jaasInspectCallback)

def inspectJaasAlias(deployedId, deployedName, jaasAliasId, container):
    inspectedProperty(deployedId, 'username', AdminConfig.showAttribute(jaasAliasId, 'userId'))
    inspectedProperty(deployedId, 'wasName', deployedName)
    inspectDeployedProperties(deployedId, deployedName, jaasAliasId, prototype)

discoverAndInspectJaasAlias()
