#
def discoverConnectionFactoryNestedObjects(deployedId,serviceClassGoalid,nestedProperty):
    attributes =AdminConfig.show(serviceClassGoalid)
    attrMap = wsadminToDict(attributes)
    for key in attrMap.keys():
        if key in goalAttributeUnits:
            inspectedProperty(deployedId, "%s%s" % (nestedProperty,key),resolveUnitsMap[attrMap[key]])
        elif key == "importance":
            inspectedProperty(deployedId, "%s%s" % (nestedProperty,key), goalAttributeImportanceMap[attrMap[key]])
        else:
            inspectedProperty(deployedId, "%s%s" % (nestedProperty,key),attrMap[key])

def resolveTransactionClass(deployedId, servicePolicy, nestedProperty, deployedName) :
    defaultName = "Default_TC_%s" % (deployedName)
    if deployedName != "Default_SP":
        transClassIds = wsadminToList(AdminConfig.showAttribute(servicePolicy, 'TransactionClasses'))
        for transactionClassId in transClassIds:
            transactionClassName = AdminConfig.showAttribute(transactionClassId, 'name')
            if transactionClassName != defaultName:
                inspectedProperty(deployedId, nestedProperty, transactionClassName)

def resolveServiceClassGoal(deployedId, importance, serviceClassGoalid):
    if serviceClassGoalid.find('DiscretionaryGoal') != -1:
        inspectedProperty(deployedId,'GoalAttributes_importance', goalAttributeImportanceMap[importance])
    elif serviceClassGoalid.find('AverageResponseTimeGoal') != -1:
        inspectedProperty(deployedId,'goalType', 'AVERAGE_RESPONSE_TIME')
        discoverConnectionFactoryNestedObjects(deployedId,serviceClassGoalid,"GoalAttributes_")
    elif serviceClassGoalid.find('PercentileResponseTimeGoal') != -1:
        inspectedProperty(deployedId,'goalType', 'PERCENTILE_RESPONSE_TIME')
        discoverConnectionFactoryNestedObjects(deployedId,serviceClassGoalid,"GoalAttributes_")

def discoverAndInspectServicePolicies(container):
    servicePolicyContainmentPath = '%s/ServiceClass:/' % (container.containmentPath)
    servicePolicies = wsadminToList(AdminConfig.getid(servicePolicyContainmentPath))
    if servicePolicies != "":
        for servicePolicy in servicePolicies:
            deployedName = AdminConfig.showAttribute(servicePolicy, 'name')
            if appendTypeToName:
                deployedId = container.id + '/' + deployedName + '_' + prototype.type
            else:
                deployedId = container.id + '/' + deployedName
            discovered(deployedId, prototype.type)
            inspectedProperty(deployedId, 'wasName', deployedName)
            inspectedProperty(deployedId, 'description', AdminConfig.showAttribute(servicePolicy, 'description'))
            resolveTransactionClass(deployedId, servicePolicy, "additionalTransactionClasses", deployedName)
            serviceClassGoalid = AdminConfig.showAttribute(servicePolicy, 'ServiceClassGoal')
            resolveServiceClassGoal(deployedId, AdminConfig.showAttribute(serviceClassGoalid, 'importance'), serviceClassGoalid)
            inspectedItem(deployedId)

for c in findAllContainers(container):
    discoverAndInspectServicePolicies(c)
