#
def attributeExists(targetId, container, targetAttribute):
    return targetAttribute in getConfigTypeAttrs(getObjectType(container, targetId))

def getTarget(deployed, container, failOnMissing = True):
    targetType = container.wasConfigIdType
    if targetType == 'Server':
        targetId = validateNotEmpty(AdminConfig.getid('%s/ApplicationServer:/' % container.containmentPath), "Cannot find WebSphere container '%s'" % container.name)
    else:
        targetId = validateNotEmpty(AdminConfig.getid(container.containmentPath), "Cannot find WebSphere container '%s'" % container.name)
    if deployed.targetComponent:
        for targetType in deployed.targetComponent.split("."):
            targets = wsadminToList(AdminConfig.list(targetType, targetId))
            if len(targets) == 0:
                print "Cannot find target component of type '%s' in container '%s'" % (targetType, targetId)
                if failOnMissing:
                    sys.exit(1)
            else:
                targetId = targets[0]

    if failOnMissing and not attributeExists(targetId, container, deployed.targetAttribute):
        printErrorAndExit("Cannot find target attribute '%s' in container '%s'" % (deployed.targetAttribute, targetId))

    return targetId

def getProperties(deployed, container, targetId):
    if targetId and attributeExists(targetId, container, deployed.targetAttribute):
        return wsadminToList(AdminConfig.showAttribute(targetId, deployed.targetAttribute))
    else:
        print "No properties for attribute '%s' discovered in container '%s'" % (deployed.targetAttribute, targetId)
    return []