mailPropertiesList = ['mailStoreHost', 'mailStoreUser', 'mailStorePassword', 'mailFrom', 'mailTransportHost', 'mailTransportUser', 'mailTransportPassword']

def inspectNestedMailSessionsInContainer(deployedId, mailSession, nestedProperty, property):
    nestedPropId = AdminConfig.showAttribute(mailSession, nestedProperty)
    if nestedPropId:
        inspectedProperty(deployedId, nestedProperty, AdminConfig.showAttribute(nestedPropId, property))

def discoverAndInspectMailSessionsInContainer(container):
    containerId = AdminConfig.getid(container.containmentPath)

    providerContainmentPath = '%s/MailProvider:/' % (container.containmentPath)
    providers = validateNotEmpty(wsadminToList(AdminConfig.getid(providerContainmentPath)), "Cannot locate Mail Provider containment path '%s'" % (providerContainmentPath))
    for mailProvider in providers:
        mailSessions = wsadminToList(AdminConfig.list('MailSession', mailProvider))
        for mailSession in mailSessions:
            deployedName = AdminConfig.showAttribute(mailSession, 'name')
            if appendTypeToName:
                deployedId = container.id + '/' + deployedName + '_' + prototype.type
            else:
                deployedId = container.id + '/' + deployedName
            discovered(deployedId, prototype.type)
            inspectedProperty(deployedId, 'wasName', deployedName)
            inspectDeployedProperties(deployedId, deployedName, mailSession, prototype)
            inspectNestedMailSessionsInContainer(deployedId, mailSession, 'mailStoreProtocol', 'protocol')
            inspectNestedMailSessionsInContainer(deployedId, mailSession, 'mailTransportProtocol', 'protocol')
            inspectNestedMailSessionsInContainer(deployedId, mailSession, 'provider', 'name')
            for property in mailPropertiesList:
                inspectedProperty(deployedId, property, AdminConfig.showAttribute(mailSession, property))
            inspectNestedJ2EEResourceProperties(deployedId, mailSession, "propertySet", "customProperties")
            inspectedItem(deployedId)

for c in findAllContainers(container):
    discoverAndInspectMailSessionsInContainer(c)
