/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.deployed.datasource;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.contributor.CollectDeployedsOfTypesContributor;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedResource;
import com.xebialabs.deployit.plugin.was.util.Predicates;
import java.util.Map;

public class TestDatasourceContributor
extends CollectDeployedsOfTypesContributor<ExtensibleDeployedResource> {
    private static final Type DATASOURCE_TYPE = Type.valueOf((String)"was.Datasource");
    private static final String DATASOURCE_TEST_CONNECTION_PROPERTY = "testConnection";
    private static final String TEST_CONNECTION_SCRIPT_PROPERTY = "testConnectionScript";
    private static final String TEST_CONNECTION_ORDER_PROPERTY = "testConnectionOrder";

    public TestDatasourceContributor() {
        super(DATASOURCE_TYPE);
    }

    @Contributor
    public static void addTestConnectionSteps(Deltas deltas, DeploymentPlanningContext ctx) {
        TestDatasourceContributor contributor = new TestDatasourceContributor();
        contributor.filterDeltas(deltas.getDeltas());
        contributor.addTestConnectionStep(ctx);
    }

    private void addTestConnectionStep(DeploymentPlanningContext ctx) {
        Iterable createdOrModifiedDatasources = Iterables.concat((Iterable)this.deployedsCreated, (Iterable)Iterables.transform((Iterable)this.deployedsModified, Predicates.extractDeployed()));
        for (Deployed datasource : createdOrModifiedDatasources) {
            if (!Boolean.TRUE.equals(datasource.getProperty(DATASOURCE_TEST_CONNECTION_PROPERTY))) continue;
            TestDatasourceContributor.addTestConnectionStep((ExtensibleDeployedResource)datasource, ctx);
        }
    }

    public static void addTestConnectionStep(ExtensibleDeployedResource datasource, DeploymentPlanningContext ctx) {
        ctx.addStep((Step)new PythonDeploymentStep(((Integer)datasource.getProperty(TEST_CONNECTION_ORDER_PROPERTY)).intValue(), (PythonManagingContainer)((WasContainer)datasource.getContainer()).getCell(), (String)datasource.getProperty(TEST_CONNECTION_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"deployed", (Object)((Object)datasource)), String.format("Test datasource connection to '%s'", datasource.getName())));
    }
}

