def inspectenableCiphers(deployedId, nestedPropId, nestedProperty):
    ciphers = AdminConfig.showAttribute(nestedPropId, nestedProperty)
    if ciphers:
        for cipher in ciphers.split():
            inspectedProperty(deployedId, nestedProperty, cipher)

def discoverAndInspectSSLConfigInContainer():
    securityId = AdminConfig.getid("/Cell:%s/Security:/" % (container.cellName))
    sslConfigList = wsadminToList(AdminConfig.list('SSLConfig', securityId))
    for configAlias in sslConfigList:
        deployedName = AdminConfig.showAttribute(configAlias, 'alias')
        deployedId = container.id + '/' + deployedName
        discovered(deployedId, prototype.type)
        inspectedProperty(deployedId, 'type', AdminConfig.showAttribute(configAlias, 'type'))
        inspectNestedProperties(deployedId, deployedName, configAlias, "setting")
        inspectNestedProperties(deployedId, deployedName, configAlias, "managementScope")
        inspectedItem(deployedId)

discoverAndInspectSSLConfigInContainer()