def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")        #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();            #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList

def makeCommaSeparatedClassnames(loginModuleIds):
    commaSeparatedList = ''
    for loginModuleId in loginModuleIds:
        moduleClassName = AdminConfig.showAttribute(loginModuleId ,'moduleClassName')
        commaSeparatedList = commaSeparatedList + moduleClassName + ','
    if len(commaSeparatedList) > 0:
        commaSeparatedList = commaSeparatedList[0:len(commaSeparatedList) - 1]
    return commaSeparatedList

def getIndexOfElementToMove(loginModuleIds, moduleClassNameToLookFor):
    index = 0
    for loginModuleId in loginModuleIds:
        moduleClassName = AdminConfig.showAttribute(loginModuleId ,'moduleClassName')
        if moduleClassName == moduleClassNameToLookFor:
            return index
        else:
            index = index + 1
    return -1

def buildPropertiesString():
    propsString = ''
    for key, value in deployed.customProperties.items():
        propsString = propsString + '"%s=%s",' % (key, value)
    if propsString != '':
        propsString = propsString[:-1]
    return propsString
    
security = AdminConfig.list('Security')
systemLoginConfig = AdminConfig.showAttribute(security, 'systemLoginConfig' )
entries = AdminConfig.showAttribute(systemLoginConfig, 'entries')
allEntries = wsadminToList(entries)
foundAlias = 0
for entry in allEntries:
    alias = AdminConfig.showAttribute(entry, 'alias')
    if alias == deployed.aliasName:
        foundAlias = 1
        loginModules = AdminConfig.showAttribute(entry, 'loginModules')
        allLoginModules = wsadminToList(loginModules)
        if deployed.moduleOrder > (len(allLoginModules) + 1):
            print 'ERROR: can not handle ordering as specified module order is too large. It can not exceed ' + str(len(allLoginModules) + 1) + ' it is, however, ' + str(deployed.moduleOrder)
            sys.exit(1)
        foundLoginModule = 0
        for loginModule in allLoginModules:
            moduleClassName = AdminConfig.showAttribute(loginModule, 'moduleClassName')
            if moduleClassName == deployed.className:
                foundLoginModule = 1
                AdminConfig.modify(loginModule, '[["authenticationStrategy" %s]]' % deployed.strategy)
                if hasattr(deployed, 'customProperties') and deployed.customProperties != None:
                    customPropString = buildPropertiesString()
                    AdminTask.configureLoginModule('[-loginType system -loginEntryAlias %s -loginModule %s -useLoginModuleProxy false -customProperties [%s]]' % (alias, deployed.className, customPropString))
        if foundLoginModule == 0:
            newModule = AdminConfig.create('JAASLoginModule', entry, [['moduleClassName', '%s' % deployed.className ]] )
            AdminConfig.modify(newModule, [['authenticationStrategy', '%s' % deployed.strategy ]] )
            if hasattr(deployed, 'customProperties') and deployed.customProperties != None:
                customPropString = buildPropertiesString()
                AdminTask.configureLoginModule('[-loginType system -loginEntryAlias %s -loginModule %s -useLoginModuleProxy false -customProperties [%s]]' % (alias, deployed.className, customPropString))
        # handle ordering. Get the possibly modified list first
        loginModules = AdminConfig.showAttribute(entry, 'loginModules')
        allLoginModules = wsadminToList(loginModules)
        indexOfElementToMove = getIndexOfElementToMove(allLoginModules, deployed.className)
        print 'index of element to move: ' + str(indexOfElementToMove)
        if deployed.moduleOrder < len(allLoginModules):
            # first cut out the object to move 
            myPart = allLoginModules[indexOfElementToMove:indexOfElementToMove + 1]
            firstPart = allLoginModules[0:indexOfElementToMove]
            lastPart = allLoginModules[indexOfElementToMove + 1:]
            oldList = firstPart + lastPart
            # now split up the old list at appropriate place
            firstPart = oldList[0:deployed.moduleOrder - 1]
            lastPart = oldList[deployed.moduleOrder - 1:]
            newList = firstPart + myPart + lastPart
            commaSeparatedClassnames = makeCommaSeparatedClassnames(newList)
            AdminTask.configureJAASLoginEntry('[-loginEntryAlias %s -loginType system -loginModules %s ]' % (deployed.aliasName,commaSeparatedClassnames) ) 
        else:
            print 'there was no need to re-order loginModules'
        
if foundAlias == 0:
    print 'ERROR: no system login could be found with alias name: ' + deployed.aliasName
    sys.exit(1)
    
print "Saving changes"
AdminConfig.save()