def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")        #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();            #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList

def findMessagingEngine(nameToLookFor):
    messagingEngines = AdminConfig.list('SIBMessagingEngine')
    allMessagingEngines = wsadminToList(messagingEngines)
    for messagingEngine in allMessagingEngines:
        if messagingEngine.find(nameToLookFor + '(') == 0:
            return messagingEngine
    return None

cnt = 0
if deployed.relatedServer != None:
    cnt = cnt + 1
if deployed.relatedCluster != None:
    cnt = cnt + 1
if deployed.relatedMQServer != None:
    cnt = cnt + 1

if cnt == 0:
    print 'ERROR this bus member is not related to either a server, or a cluster, or a MQServer'
    print '   select either a server, or a cluster, or a MQServer'
    sys.exit(1)

if cnt > 1:
    print 'ERROR a bus member can only be related to a single configuration item.'
    print '   select only one server, or a cluster, or a MQServer'
    sys.exit(1)

if deployed.relatedCluster != None and deployed.storeDirectory == '':
    print 'ERROR the bus member represents a Cluster, which requires a store directory'
    print '   provide a value for the store directory'
    sys.exit(1)
if deployed.relatedCluster != None and deployed.logDirectory == '':
    print 'ERROR the bus member represents a Cluster, which requires a log directory'
    print '   provide a value for the log directory'
    sys.exit(1)

busName = deployed.bus.busName

if deployed.relatedServer != None:
    memberType = 'WebSphere server'
    nodeName = deployed.relatedServer.node.name
    serverName = deployed.relatedServer.name
    memberName = serverName
    AdminTask.addSIBusMember('[-bus %s -node %s -server %s -fileStore -logSize 100 -minPermanentStoreSize 200 -maxPermanentStoreSize 500 -unlimitedPermanentStoreSize false -minTemporaryStoreSize 200 -maxTemporaryStoreSize 500 -unlimitedTemporaryStoreSize false ]' % (busName, nodeName, serverName)) 
if deployed.relatedCluster != None:
    memberType = 'WebSphere cluster'
    clusterName = deployed.relatedCluster.name
    memberName = clusterName
    AdminTask.addSIBusMember('[-bus %s -cluster %s -enableAssistance true -policyName HA -fileStore -logSize 100 -minPermanentStoreSize 200 -maxPermanentStoreSize 500 -unlimitedPermanentStoreSize false -permanentStoreDirectory %s -minTemporaryStoreSize 200 -maxTemporaryStoreSize 500 -unlimitedTemporaryStoreSize false -temporaryStoreDirectory %s -logDirectory %s]' % (busName, clusterName, deployed.storeDirectory, deployed.storeDirectory, deployed.logDirectory))
if deployed.relatedMQServer != None:
    memberType = 'WebSphere MQ server'
    serverName = deployed.relatedMQServer.mqServerName
    memberName = serverName
    AdminTask.addSIBusMember('[-bus %s -wmqServer %s -virtualQueueManagerName %s ]' % (busName, serverName, busName))

if deployed.relatedServer != None:
    nameToLookFor = '%s.%s-%s' % (nodeName, serverName, busName)
    messagingEngine = findMessagingEngine(nameToLookFor)
    if messagingEngine != None:
        for key, value in deployed.customProperties.items():
            attr = [["name", key], ["value", value]]
            AdminConfig.create("Property", messagingEngine, attr)
    else:
        print 'WARNING messaging engine with name: ' + nameToLookFor + ' was not found. Custom properties not set'

print 'Added a ' + memberType + ' named ' + memberName + ' as a bus member on bus ' + busName