target = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find WebSphere config item " + deployed.container.name);

existing = {}
# will fail if no such attribute exists
customProperties = AdminConfig.showAttribute(target, 'properties')
if customProperties != "[]":
    entries = customProperties[1:-1].split()
    for entry in entries:
        name = AdminConfig.showAttribute(entry, 'name')
        existing[name] = entry

for key, value in deployed.properties.items():
    attr = [["name", key], ["value", value]]
    if existing.has_key(key):
        if deployed.overwriteExisting:
            print 'Overwriting custom property %s = %s' % (key, value)
            AdminConfig.modify(existing[key], attr)
        else:
            currentValue = AdminConfig.showAttribute(existing[key], 'value')
            print "Appending '%s' to existing custom property %s = %s" % (value, key, currentValue)
            attr = [["name", key], ["value", currentValue + value]]
            AdminConfig.modify(existing[key], attr)
    else:
        print 'Adding custom property %s = %s' % (key,value)
        AdminConfig.create("Property", target, attr)