scope = deployed.scope
providerName = deployed.provider.providerName

def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")        #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();            #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList

def findProviderByName(providers, providerName):
    for provider in providers:
        itsName = AdminConfig.showAttribute(provider, 'name')
        if itsName == providerName:
            return provider
    return None

def findProtocolProviderByProtocol(protocolProviders, protocol):
    for protocolProvider in protocolProviders:
        protocolOfProtocolProvider = AdminConfig.showAttribute(protocolProvider, 'protocol')
        if protocolOfProtocolProvider == protocol:
            return protocolProvider
    return None

if scope == 'cell':
    try:
        # should have a property 'host' and property 'nodeAgents'
        host = deployed.container.host
        nodeAgents = deployed.container.nodeAgents
    except:
        print 'ERROR you are deploying a mail session with scope: "cell" to a container that is not a cell. Its id: ' + deployed.container.id
        sys.exit(1)
    print 'Creating a Mail Session on cell scope'
    cellName = deployed.container.name
    cell = AdminConfig.getid('/Cell:%s/' % cellName)
    providers = AdminConfig.list('MailProvider', cell)
elif scope == 'server':
    try:
        # should have a property 'node', which has a 'cell' property on its own
        node = deployed.container.node
        nodeName = node.name
        cell = node.cell
        cellName = cell.name
        serverName = deployed.container.name
    except:
        print 'ERROR you are deploying a mail session with scope: "server" to a container that is not a server. Its id: ' + deployed.container.id
        sys.exit(1)
    server = AdminConfig.getid('/Node:%s/Server:%s' % (nodeName, serverName))
    providers = AdminConfig.list('MailProvider', server)

allProviders = wsadminToList(providers)
provider = findProviderByName(allProviders, providerName)

if provider is None:
    print 'ERROR can not find provider ' + providerName + ' on scope ' + scope
    sys.exit(1)

protocolProviders = AdminConfig.showAttribute(provider, 'protocolProviders')
allProtocolProviders = wsadminToList(protocolProviders)
storeProtocolProvider = findProtocolProviderByProtocol(allProtocolProviders, deployed.mailStoreProtocol)
if storeProtocolProvider is None:
    print 'ERROR can not find protocol ' + deployed.mailStoreProtocol + ' on mail provider with id ' + deployed.provider.id
    sys.exit(1)
transportProtocolProvider = findProtocolProviderByProtocol(allProtocolProviders, deployed.mailTransportProtocol)
if transportProtocolProvider is None:
    print 'ERROR can not find protocol ' + deployed.mailStoreProtocol + ' on mail provider with id ' + deployed.provider.id
    sys.exit(1)

# create all args (in == store and out == transport so to say)
argList = '[[debug "false"] [name "%s"] [mailStoreUser "%s"] [category ""] [mailTransportHost "%s"] [jndiName "%s"] [mailTransportUser "%s"] [mailStorePassword "%s"] [mailStoreHost "%s"] [strict "true"] [mailTransportPassword "%s"]  [description "%s"] [mailFrom "%s"] [mailStoreProtocol %s] [mailTransportProtocol %s]]' % (deployed.mailSessionName, deployed.mailStoreUser, deployed.mailTransportHost, deployed.jndiName, deployed.mailTransportUser, deployed.mailStorePassword, deployed.mailStoreHost, deployed.mailTransportPassword, deployed.description, deployed.mailFrom, storeProtocolProvider, transportProtocolProvider)
AdminConfig.create('MailSession', provider, argList);

print 'Created mail session ' + deployed.mailSessionName + ' on provider ' + providerName