/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.planning;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.community.wasext.planning.StopAndStartColdDeploymentContainers;
import com.xebialabs.deployit.community.wasext.task.ClusterTasks;
import com.xebialabs.deployit.community.wasext.task.ManagedServerTasks;
import com.xebialabs.deployit.community.wasext.util.Predicates;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.SingleTypeContributor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.was.container.Cluster;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedResource;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartReferencedContainers
extends SingleTypeContributor<ExtensibleDeployedResource> {
    private static final String CONTAINER_RESTART_REQUIRED_PROPERTY = "containerRestartRequired";
    private static final Predicate<ConfigurationItem> IS_CLUSTER = new Predicate<ConfigurationItem>(){

        public boolean apply(ConfigurationItem input) {
            return Predicates.instanceOf(Type.valueOf(Cluster.class)).apply((Object)input);
        }
    };
    private static final Predicate<ConfigurationItem> IS_MANAGED_SERVER = new Predicate<ConfigurationItem>(){

        public boolean apply(ConfigurationItem input) {
            return Predicates.instanceOf(Type.valueOf(ManagedServer.class)).apply((Object)input);
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(RestartReferencedContainers.class);

    public RestartReferencedContainers() {
        super(ExtensibleDeployedResource.class);
    }

    @Contributor
    public void restartContainers(Deltas deltas, DeploymentPlanningContext ctx) {
        this.filterDeltas(deltas.getDeltas());
        for (WasContainer container : this.getReferencedContainers()) {
            if (StopAndStartColdDeploymentContainers.isColdDeployContainer(container)) continue;
            this.restart(container, ctx);
        }
    }

    private Set<WasContainer> getReferencedContainers() {
        ImmutableSet.Builder containers = ImmutableSet.builder();
        Iterable changedDeployeds = Iterables.concat((Iterable)this.deployedsCreated, (Iterable)Iterables.transform((Iterable)this.deployedsModified, (Function)Functions.compose(Predicates.cast(ExtensibleDeployedResource.class), Predicates.extractDeployed())), (Iterable)this.deployedsRemoved);
        for (ExtensibleDeployedResource deployed : changedDeployeds) {
            if (!deployed.hasProperty(CONTAINER_RESTART_REQUIRED_PROPERTY) || !Boolean.TRUE.equals(deployed.getProperty(CONTAINER_RESTART_REQUIRED_PROPERTY))) continue;
            containers.add((Object)deployed.getContainer());
        }
        return containers.build();
    }

    protected void restart(WasContainer container, DeploymentPlanningContext ctx) {
        if (IS_CLUSTER.apply((Object)container)) {
            ClusterTasks.restart((Cluster)container, ctx);
        } else if (IS_MANAGED_SERVER.apply((Object)container)) {
            ManagedServerTasks.restart((ManagedServer)container, ctx);
        } else {
            LOGGER.warn("Unable to generate automatic restart steps for unsupported WebSphere container type '{}'", (Object)Type.valueOf(container.getClass()));
        }
    }
}

