from com.ibm.ws.scripting import ScriptingException

print "Stopping server '%s' on node '%s'" % (container.name, container.nodeName)
try:
  AdminControl.stopServer(container.name, container.nodeName)
except ScriptingException:
  output = "%s" % (sys.exc_info()[1])
  if output.find("Unable to locate running server") != -1:
    print "WARN: Server '%s' is not running on node '%s'. Nothing to do." % (container.name, container.nodeName)
  else:
    print "An error occurred while stopping a server '%s' on node '%s': %s" % (container.name, container.nodeName, output)
    raise Exception("An error occurred while stopping a server '%s' on node '%s': %s" % (container.name, container.nodeName, output))


print "Starting server '%s' on node '%s'" % (container.name, container.nodeName)
try:
  AdminControl.startServer(container.name, container.nodeName)
except ScriptingException:
  output = "%s" % (sys.exc_info()[1])
  if output.find("is already running on node") != -1:
    print "WARN: Server '%s' is already running on node '%s'. Nothing to do." % (container.name, container.nodeName)
  else:
    print "An error occurred while starting a server '%s' on node '%s': %s" % (container.name, container.nodeName, output)
    raise Exception("An error occurred while starting a server '%s' on node '%s': %s" % (container.name, container.nodeName, output))

