/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.planning;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.community.wasext.util.Predicates;
import com.xebialabs.deployit.plugin.api.deployment.planning.SingleTypeContributor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;
import java.util.Set;

public abstract class ReferencedCellContributor
extends SingleTypeContributor<ExtensibleDeployedArtifact> {
    private static final Predicate<ConfigurationItem> IS_EAR_OR_WAR_MODULE = com.google.common.base.Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(Type.valueOf((String)"was.EarModule")), Predicates.instanceOf(Type.valueOf((String)"was.WarModule")), Predicates.instanceOf(Type.valueOf((String)"wps.EarModule"))});

    public ReferencedCellContributor() {
        super(ExtensibleDeployedArtifact.class);
    }

    protected Set<Cell> getReferencedCells() {
        ImmutableSet.Builder cells = ImmutableSet.builder();
        for (ExtensibleDeployedArtifact earOrWarModule : this.getEarAndWarModules()) {
            cells.add((Object)((WasContainer)earOrWarModule.getContainer()).getCell());
        }
        return cells.build();
    }

    private Set<ExtensibleDeployedArtifact> getEarAndWarModules() {
        ImmutableSet.Builder earAndWarModules = ImmutableSet.builder();
        earAndWarModules.addAll(Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsCreated, (Iterable)this.deployedsRemoved), IS_EAR_OR_WAR_MODULE));
        Iterable earAndWarModuleDeltas = Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsModified, (Iterable)this.deployedsNoop), (Predicate)new Predicate<SingleTypeContributor.TypedDelta>(){

            public boolean apply(SingleTypeContributor.TypedDelta input) {
                return IS_EAR_OR_WAR_MODULE.apply(input.getDeployed());
            }
        });
        for (SingleTypeContributor.TypedDelta earOrWarModuleDelta : earAndWarModuleDeltas) {
            earAndWarModules.add(earOrWarModuleDelta.getPrevious());
            earAndWarModules.add(earOrWarModuleDelta.getDeployed());
        }
        return earAndWarModules.build();
    }
}

