/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.ctrltask;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FullCycleDmgrAndNodeAgents {
    private static final String STOP_WRAPPER_SCRIPT = "wasx/container/stopDmgrAndNodeAgents";
    private static final String START_WRAPPER_SCRIPT = "wasx/container/startDmgrAndNodeAgents";
    public static final String PROFILE_HOST = "profileHost";
    public static final String PROFILE_HOME = "profileHome";

    @Delegate(name="CycleDmgrAndNodeAgents")
    public List<Step> cycleDmgrAndNodeAgents(ConfigurationItem ci, String method, Map<String, String> args) {
        Preconditions.checkArgument((boolean)ci.getType().equals((Object)Type.valueOf(DeploymentManager.class)), (Object)"Control Task delegate can only be used with a DeploymentManager");
        DeploymentManager dmgr = (DeploymentManager)ci;
        Iterable<? extends Node> nodes = this.findAllNodeAgentWhoseProfileHomeIsSet(dmgr);
        ArrayList steps = Lists.newArrayList();
        HashMap commonCtx = Maps.newHashMap();
        commonCtx.put("args", args);
        commonCtx.put("deploymentManager", dmgr);
        this.addSteps(method, steps, (ConfigurationItem)dmgr, commonCtx, dmgr.getHost());
        for (Node node : nodes) {
            HashMap ctx = Maps.newHashMap((Map)commonCtx);
            ctx.put("node", node);
            Host host = dmgr.getHost();
            if (node.hasProperty(PROFILE_HOST) && node.getProperty(PROFILE_HOST) != null) {
                host = (Host)node.getProperty(PROFILE_HOST);
            }
            this.addSteps(method, steps, (ConfigurationItem)node, ctx, host);
        }
        return steps;
    }

    private void addSteps(String method, List<Step> steps, ConfigurationItem ci, Map<String, Object> ctx, Host host) {
        if ("restartDmgrAndAgents".equals(method)) {
            steps.add(this.stopStep(host, ctx, ci));
            steps.add(this.startStep(host, ctx, ci));
        } else if ("stopDmgrAndAgents".equals(method)) {
            steps.add(this.stopStep(host, ctx, ci));
        } else if ("startDmgrAndAgents".equals(method)) {
            steps.add(this.startStep(host, ctx, ci));
        }
    }

    private Step stopStep(Host host, Map<String, Object> ctx, ConfigurationItem ci) {
        return new ScriptExecutionStep(1, STOP_WRAPPER_SCRIPT, (HostContainer)host, ctx, "Stopping " + ci);
    }

    private Step startStep(Host host, Map<String, Object> ctx, ConfigurationItem ci) {
        return new ScriptExecutionStep(1, START_WRAPPER_SCRIPT, (HostContainer)host, ctx, "Starting " + ci);
    }

    private Iterable<? extends Node> findAllNodeAgentWhoseProfileHomeIsSet(DeploymentManager dmgr) {
        return Iterables.filter((Iterable)dmgr.getNodes(), (Predicate)new Predicate<Node>(){

            public boolean apply(Node input) {
                return input.hasProperty(FullCycleDmgrAndNodeAgents.PROFILE_HOME) && !Strings.isNullOrEmpty((String)((String)input.getProperty(FullCycleDmgrAndNodeAgents.PROFILE_HOME)));
            }
        });
    }
}

