/*
 * @(#)SqlScriptOrderer.java     1 Sep 2011
 *
 * Copyright © 2010 Andrew Phillips.
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */
package com.xebialabs.deployit.community.wasext.planning;


import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSet.Builder;
import com.xebialabs.deployit.plugin.api.deployment.planning.SingleTypeContributor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;

import java.util.Set;

import static com.google.common.base.Predicates.or;
import static com.google.common.collect.Iterables.concat;
import static com.google.common.collect.Iterables.filter;
import static com.xebialabs.deployit.community.wasext.util.Predicates.instanceOf;

public abstract class ReferencedCellContributor extends SingleTypeContributor<ExtensibleDeployedArtifact> {

    private static final Predicate<ConfigurationItem> IS_EAR_OR_WAR_MODULE =
        or(instanceOf(Type.valueOf("was.EarModule")),
           instanceOf(Type.valueOf("was.WarModule")),
           instanceOf(Type.valueOf("wps.EarModule")));

    public ReferencedCellContributor() {
        super(ExtensibleDeployedArtifact.class);
    }
    
    protected Set<Cell> getReferencedCells() {
        Builder<Cell> cells = ImmutableSet.builder();
        
        // gather all referenced cells
        for (ExtensibleDeployedArtifact earOrWarModule : getEarAndWarModules()) {
            cells.add(earOrWarModule.getContainer().getCell());
        }
        return cells.build();
    }

    private Set<ExtensibleDeployedArtifact> getEarAndWarModules() {
        Builder<ExtensibleDeployedArtifact> earAndWarModules = ImmutableSet.builder();
        earAndWarModules.addAll(filter(concat(deployedsCreated, deployedsRemoved), IS_EAR_OR_WAR_MODULE));
        Iterable<TypedDelta> earAndWarModuleDeltas = filter(concat(deployedsModified, deployedsNoop), 
                new Predicate<TypedDelta>() {
                    @Override
                    public boolean apply(TypedDelta input) {
                        return IS_EAR_OR_WAR_MODULE.apply(input.getDeployed());
                    }
                });
        for (TypedDelta earOrWarModuleDelta : earAndWarModuleDeltas) {
            earAndWarModules.add(earOrWarModuleDelta.getPrevious());
            earAndWarModules.add(earOrWarModuleDelta.getDeployed());
        }
        return earAndWarModules.build();
    }
}