containmentPath = '%s/CoreGroup:%s' % (deployed.container.containmentPath, deployed.name)
id = validateNotEmpty(AdminConfig.getid(containmentPath), "Cannot find " + containmentPath)

defaultCoreGroup = AdminTask.getDefaultCoreGroupName()
for cluster in deployed.coreGroupClusters:
    containerConfigType = cluster.wasConfigIdType
    if containerConfigType == 'DynamicCluster':
        print "Returning cluster '%s' to default Core Group '%s'" % (cluster.name, defaultCoreGroup)
        AdminTask.moveClusterToCoreGroup("[-source %s -target %s -clusterName %s]" % (deployed.name, defaultCoreGroup, cluster.name))
        # cluster.containmentPath uses config type 'ServerCluster'
        serverTemplateContainmentPath = "%s/DynamicCluster:%s/Server:%s/HAManagerService:/" % (deployed.container.containmentPath, cluster.name, cluster.name)
        serverTemplateHaManagerId = validateNotEmpty(AdminConfig.getid(serverTemplateContainmentPath), "Unable to find '%s'" % (serverTemplateContainmentPath))
        print "Setting server template Core Group back to '%s'" % (defaultCoreGroup)
        AdminConfig.modify(serverTemplateHaManagerId, "[[coreGroupName %s]]" % (defaultCoreGroup))
    elif containerConfigType == 'ServerCluster':
        if len(cluster.servers) == 0:
            print "Ignoring empty cluster '%s'" % (cluster.name)
        else:
            print "Returning cluster '%s' to default Core Group '%s'" % (cluster.name, defaultCoreGroup)
            AdminTask.moveClusterToCoreGroup("[-source %s -target %s -clusterName %s]" % (deployed.name, defaultCoreGroup, cluster.name))

for server in deployed.coreGroupServers:
    print "Returning server '%s' to default Core Group '%s'" % (server.name, defaultCoreGroup)
    AdminTask.moveServerToCoreGroup("[-source %s -target %s -nodeName %s -serverName %s]" % (deployed.name, defaultCoreGroup, server.nodeName, server.name))

print "Destroying Core Group %s" % (deployed.name)
AdminConfig.remove(id)