def getVersion(wasContainer):
  if hasattr(wasContainer, 'node'):
    return wasContainer.node.cell.version
  if hasattr(wasContainer, 'cell'):
    return wasContainer.cell.version
  else:
    return wasContainer.version

exposedProperties = deployed.getExposedProperties(True)

if getVersion(deployed.container) == 'WAS_61':
  # the was-plugin-extensions use a different key
  exposedProperties['baseQueueName'] = exposedProperties['queueName']
  del exposedProperties['queueName']
  if 'useRFH2' in exposedProperties.keys():
    print "WARN: Ignoring property 'useRFH2' which is not supported on WAS 6.1"
    del exposedProperties['useRFH2']
  if 'qmgr' in exposedProperties.keys():
    print "WARN: Ignoring property 'qmgr' which is not supported on WAS 6.1"
    del exposedProperties['qmgr']
  
  jmsProviderContainmentPath = '%s/JMSProvider:%s' % (deployed.container.containmentPath, deployed.jmsProvider)
  jmsProviderId = validateNotEmpty(AdminConfig.getid(jmsProviderContainmentPath), "Cannot find WebSphere JMS Provider " + deployed.jmsProvider);
  args = toAdminConfigArgs(exposedProperties)
  
  print "Creating %s for provider %s with args %s " % (deployed.wasType, jmsProviderId, args)
  AdminConfig.create(deployed.wasType, jmsProviderId, args)
else:
  parent = AdminConfig.getid(deployed.container.containmentPath)
  args = toAdminTaskArgs(exposedProperties)
  
  print "Creating WMQ Queue queue on target scope %s with args %s" %(parent, args)
  AdminTask.createWMQQueue(parent, args)