def getVersion(wasContainer):
  if hasattr(wasContainer, 'node'):
    return wasContainer.node.cell.version
  if hasattr(wasContainer, 'cell'):
    return wasContainer.cell.version
  else:
    return wasContainer.version

def timeUnitToNumber(goalAttributes, property):
    if goalAttributes[property] == 'MILLISECONDS':
        goalAttributes[property] = '0'
    elif goalAttributes[property] == 'SECONDS':
        goalAttributes[property] = '1'
    elif goalAttributes[property] == 'MINUTES':
        goalAttributes[property] = '2'

def importanceToNumber(goalAttributes, property):
    if goalAttributes[property] == 'HIGHEST':
        goalAttributes[property] = '1'
    elif goalAttributes[property] == 'VERY_HIGH':
        goalAttributes[property] = '15'
    elif goalAttributes[property] == 'HIGH':
        goalAttributes[property] = '35'
    elif goalAttributes[property] == 'MEDIUM':
        goalAttributes[property] = '50'
    elif goalAttributes[property] == 'LOW':
        goalAttributes[property] = '65'
    elif goalAttributes[property] == 'VERY_LOW':
        goalAttributes[property] = '85'
    elif goalAttributes[property] == 'LOWEST':
        goalAttributes[property] = '99'

containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find %s" % (deployed.container.name))

args = toAdminConfigArgs(deployed.getExposedProperties(True))
print "Creating Service Policy %s for '%s': %s" % (deployed.name, deployed.container.name, args)
servicePolicyId = AdminConfig.create("ServiceClass", containerId, args)

for transactionClassName in deployed.additionalTransactionClasses:
    tcArgs = [['name', transactionClassName]]
    print "Creating additional transaction class %s for %s: %s" % (transactionClassName, deployed.name, tcArgs)
    AdminConfig.create("TransactionClass", servicePolicyId, tcArgs)

goalAttributes = deployed.GoalAttributes.getExposedProperties(True)
if 'importance' in goalAttributes.keys():
    importanceToNumber(goalAttributes, 'importance')

if deployed.goalType == 'DISCRETIONARY':
    discretionaryGoalAttributes = {}
    if getVersion(deployed.container) != 'WAS_61':
        # importance is not supported in 6.1
        if 'importance' in goalAttributes.keys():
            discretionaryGoalAttributes['importance'] = goalAttributes['importance']
    goalArgs = toAdminConfigArgs(discretionaryGoalAttributes)
    print "Creating Discretionary goal for %s: %s" % (deployed.name, goalArgs)
    AdminConfig.create("DiscretionaryGoal", servicePolicyId, goalArgs)
else:
    if 'goalValueUnits' in goalAttributes.keys():
        timeUnitToNumber(goalAttributes, 'goalValueUnits')
    if 'goalDeltaValueUnits' in goalAttributes.keys():
        timeUnitToNumber(goalAttributes, 'goalDeltaValueUnits')
    if 'timePeriodValueUnits' in goalAttributes.keys():
        timeUnitToNumber(goalAttributes, 'timePeriodValueUnits')
    if deployed.goalType == 'AVERAGE_RESPONSE_TIME':
        if 'goalPercent' in goalAttributes.keys():
            print "WARN: Ignoring property 'goalPercent' which is not supported for Average Response Time goals"
            del goalAttributes['goalPercent']
        if 'goalDeltaPercent' in goalAttributes.keys():
            print "WARN: Ignoring property 'goalDeltaPercent' which is not supported for Average Response Time goals"
            del goalAttributes['goalDeltaPercent']
        goalArgs = toAdminConfigArgs(goalAttributes)
        print "Creating Average Response Time goal for %s: %s" % (deployed.name, goalArgs)
        AdminConfig.create("AverageResponseTimeGoal", servicePolicyId, goalArgs)
    elif deployed.goalType == 'PERCENTILE_RESPONSE_TIME':
        goalArgs = toAdminConfigArgs(goalAttributes)
        print "Creating Percentile Response Time goal for %s: %s" % (deployed.name, goalArgs)
        AdminConfig.create("PercentileResponseTimeGoal", servicePolicyId, goalArgs)