def noneOrEmpty(string):
  return string is None or string == ''

clusterId = validateNotEmpty(AdminConfig.getid("/DynamicCluster:%s/" % (container.name)), "Cannot find dynamic cluster '%s'" % (container.name));

args = [['membershipPolicy', container.membershipPolicy]]
if not noneOrEmpty(container.minInstances):
  args.append(['minInstances', str(container.minInstances)])
if not noneOrEmpty(container.maxInstances):
  args.append(['maxInstances', str(container.maxInstances)])
if not noneOrEmpty(container.numVerticalInstances):
  args.append(['numVerticalInstances', str(container.numVerticalInstances)])

print "Modifying dynamic cluster '%s' using %s" % (container.name, args)
AdminConfig.modify(clusterId, args)
print "Saving configuration"
AdminConfig.save()