/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.Collection;

public class Predicates {
    public static Predicate<Type> subtypeOf(Type type) {
        return new IsSubtypeOf(type);
    }

    public static Predicate<ConfigurationItem> instanceOf(Type type) {
        return com.google.common.base.Predicates.compose(Predicates.subtypeOf(type), (Function)new Function<ConfigurationItem, Type>(){

            public Type apply(ConfigurationItem configurationItem) {
                return configurationItem.getType();
            }
        });
    }

    public static Predicate<Delta> deltaOf(Type type) {
        return com.google.common.base.Predicates.compose(Predicates.instanceOf(type), Predicates.extractDeployed());
    }

    public static Function<Delta, Deployed<?, ?>> extractDeployed() {
        return new ExtractDeployed();
    }

    public static Predicate<Delta> operationIs(Operation operation) {
        return new OperationEquals(operation);
    }

    public static <T> Function<Object, T> cast(Class<T> clazz) {
        return new Cast(clazz);
    }

    private static class Cast<T>
    implements Function<Object, T> {
        private final Class<T> targetClass;

        private Cast(Class<T> clazz) {
            this.targetClass = clazz;
        }

        public T apply(Object object) {
            return this.targetClass.cast(object);
        }
    }

    private static class ExtractDeployed
    implements Function<Delta, Deployed<?, ?>> {
        private ExtractDeployed() {
        }

        public Deployed<?, ?> apply(Delta delta) {
            return delta.getOperation().equals((Object)Operation.DESTROY) ? delta.getPrevious() : delta.getDeployed();
        }
    }

    private static class IsSubtypeOf
    implements Predicate<Type> {
        private final Collection<Type> subtypes;

        public IsSubtypeOf(Type type) {
            this.subtypes = Sets.newHashSet((Iterable)DescriptorRegistry.getSubtypes((Type)type));
            this.subtypes.add(type);
        }

        public boolean apply(Type type) {
            return this.subtypes.contains(type);
        }
    }

    private static class OperationEquals
    implements Predicate<Delta> {
        private final Operation operationToMatch;

        protected OperationEquals(Operation operation) {
            this.operationToMatch = operation;
        }

        public boolean apply(Delta delta) {
            return delta.getOperation().equals((Object)this.operationToMatch);
        }
    }
}

