/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.task;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.community.wasext.step.ManagedWebServerPluginConfigurationCopyStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import java.util.Map;

public class ManagedWebServerTasks {
    private static final String STOP_SCRIPT_PROPERTY = "stopScript";
    private static final String START_SCRIPT_PROPERTY = "startScript";
    private static final String STOP_ORDER_PROPERTY = "stopOrder";
    private static final String START_ORDER_PROPERTY = "startOrder";
    private static final String GENERATE_PLUGIN_SCRIPT_PROPERTY = "generatePluginScript";
    private static final String PROPAGATE_PLUGIN_SCRIPT_PROPERTY = "propagatePluginScript";
    private static final String GENERATE_PLUGIN_ORDER_PROPERTY = "generatePluginOrder";
    private static final String PROPAGATE_PLUGIN_ORDER_PROPERTY = "propagatePluginOrder";

    public static void stop(ManagedWebServer managedWebServer, DeploymentPlanningContext deploymentPlanningContext) {
        ManagedWebServerTasks.stop(managedWebServer, deploymentPlanningContext, (Integer)managedWebServer.getProperty(STOP_ORDER_PROPERTY));
    }

    protected static void stop(ManagedWebServer managedWebServer, DeploymentPlanningContext deploymentPlanningContext, int n) {
        deploymentPlanningContext.addStep((Step)new PythonDeploymentStep(n, (PythonManagingContainer)managedWebServer.getNode().getCell(), (String)managedWebServer.getProperty(STOP_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)managedWebServer), String.format("Stop web server '%s'", managedWebServer.getName())));
    }

    public static void start(ManagedWebServer managedWebServer, DeploymentPlanningContext deploymentPlanningContext) {
        ManagedWebServerTasks.start(managedWebServer, deploymentPlanningContext, (Integer)managedWebServer.getProperty(START_ORDER_PROPERTY));
    }

    protected static void start(ManagedWebServer managedWebServer, DeploymentPlanningContext deploymentPlanningContext, int n) {
        deploymentPlanningContext.addStep((Step)new PythonDeploymentStep(n, (PythonManagingContainer)managedWebServer.getNode().getCell(), (String)managedWebServer.getProperty(START_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)managedWebServer), String.format("Start web server '%s'", managedWebServer.getName())));
    }

    public static void restart(ManagedWebServer managedWebServer, DeploymentPlanningContext deploymentPlanningContext) {
        int n = (Integer)managedWebServer.getProperty(START_ORDER_PROPERTY);
        ManagedWebServerTasks.stop(managedWebServer, deploymentPlanningContext, n - 2);
        ManagedWebServerTasks.start(managedWebServer, deploymentPlanningContext, n);
    }

    public static void generatePlugin(ManagedWebServer managedWebServer, DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addStep((Step)new PythonDeploymentStep(((Integer)managedWebServer.getProperty(GENERATE_PLUGIN_ORDER_PROPERTY)).intValue(), (PythonManagingContainer)managedWebServer.getNode().getCell(), (String)managedWebServer.getProperty(GENERATE_PLUGIN_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)managedWebServer), String.format("Generate web server plugin for '%s'", managedWebServer.getName())));
    }

    public static void propagatePlugin(ManagedWebServer managedWebServer, DeploymentPlanningContext deploymentPlanningContext) {
        Integer n = (Integer)managedWebServer.getProperty(PROPAGATE_PLUGIN_ORDER_PROPERTY);
        if (managedWebServer.getProperty("host") != null) {
            deploymentPlanningContext.addStep((DeploymentStep)new ManagedWebServerPluginConfigurationCopyStep(n, managedWebServer));
        } else {
            deploymentPlanningContext.addStep((Step)new PythonDeploymentStep(n.intValue(), (PythonManagingContainer)managedWebServer.getNode().getCell(), (String)managedWebServer.getProperty(PROPAGATE_PLUGIN_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)managedWebServer), String.format("Propagate web server plugin to '%s'", managedWebServer.getName())));
        }
    }
}

