/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.step;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereFileCopier;
import java.io.Closeable;

public class ManagedWebServerPluginConfigurationCopyStep
implements DeploymentStep {
    private final int order;
    private final String description;
    private final Host srcHost;
    private final Host targetHost;
    private final String pluginSrcFilePath;
    private final String pluginDestFilePath;

    public ManagedWebServerPluginConfigurationCopyStep(int n, ManagedWebServer managedWebServer) {
        this.order = n;
        Node node = managedWebServer.getNode();
        this.srcHost = node.getCell().getCellHost();
        this.targetHost = (Host)managedWebServer.getProperty("host");
        this.pluginSrcFilePath = String.format("%s/config/cells/%s/nodes/%s/servers/%s/plugin-cfg.xml", node.getCell().getWasHome(), node.getCellName(), node.getNodeName(), managedWebServer.getName().trim());
        this.pluginDestFilePath = (String)Preconditions.checkNotNull((Object)managedWebServer.getProperty("pluginConfigurationPath"), (Object)"pluginConfigurationPath");
        this.description = String.format("Copy WebSphere plugin configuration file directly to '%s' for unmanaged webserver '%s'", this.targetHost.getName(), managedWebServer.getName());
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) throws Exception {
        OverthereConnection overthereConnection = this.srcHost.getConnection();
        OverthereConnection overthereConnection2 = this.targetHost.getConnection();
        try {
            OverthereFile overthereFile = overthereConnection.getFile(this.pluginSrcFilePath);
            OverthereFile overthereFile2 = overthereConnection2.getFile(this.pluginDestFilePath);
            deploymentExecutionContext.logOutput(String.format("Copying generated plugin configuration file from '%s' on '%s' to '%s' on '%s'", this.pluginSrcFilePath, this.srcHost, this.pluginDestFilePath, this.targetHost));
            OverthereFileCopier.copy((OverthereFile)overthereFile, (OverthereFile)overthereFile2);
        }
        finally {
            Closeables.closeQuietly((Closeable)overthereConnection);
            Closeables.closeQuietly((Closeable)overthereConnection2);
        }
        return Step.Result.Success;
    }

    public int getOrder() {
        return this.order;
    }
}

