/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.planning;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.community.wasext.util.Predicates;
import com.xebialabs.deployit.plugin.api.deployment.planning.SingleTypeContributor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;
import java.util.Set;

public abstract class ReferencedCellContributor
extends SingleTypeContributor<ExtensibleDeployedArtifact> {
    private static final Predicate<ConfigurationItem> IS_EAR_OR_WAR_MODULE = com.google.common.base.Predicates.or(Predicates.instanceOf(Type.valueOf((String)"was.EarModule")), Predicates.instanceOf(Type.valueOf((String)"was.WarModule")));

    public ReferencedCellContributor() {
        super(ExtensibleDeployedArtifact.class);
    }

    protected Set<Cell> getReferencedCells() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ExtensibleDeployedArtifact extensibleDeployedArtifact : this.getEarAndWarModules()) {
            builder.add((Object)((WasContainer)extensibleDeployedArtifact.getContainer()).getCell());
        }
        return builder.build();
    }

    private Set<ExtensibleDeployedArtifact> getEarAndWarModules() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsCreated, (Iterable)this.deployedsRemoved), IS_EAR_OR_WAR_MODULE));
        Iterable iterable = Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsModified, (Iterable)this.deployedsNoop), (Predicate)new Predicate<SingleTypeContributor.TypedDelta>(){

            public boolean apply(SingleTypeContributor.TypedDelta typedDelta) {
                return IS_EAR_OR_WAR_MODULE.apply(typedDelta.getDeployed());
            }
        });
        for (SingleTypeContributor.TypedDelta typedDelta : iterable) {
            builder.add(typedDelta.getPrevious());
            builder.add(typedDelta.getDeployed());
        }
        return builder.build();
    }
}

