scope = deployed.scope

if scope == 'cell':
    try:
        # should have a property 'host' and property 'nodeAgents'
        host = deployed.container.host
        nodeAgents = deployed.container.nodeAgents
    except:
        print 'ERROR you are deploying a mail provider with scope: "cell" to a container that is not a cell. Its id: ' + deployed.container.id
        sys.exit(1)
    print 'Creating a Mail Provider on cell scope'
    cellName = deployed.container.name
elif scope == 'server':
    try:
        # should have a property 'node', which has a 'cell' property on its own
        node = deployed.container.node
        nodeName = node.name
        cell = node.cell
        cellName = cell.name
        serverName = deployed.container.name
    except:
        print 'ERROR you are deploying a mail provider with scope: "server" to a container that is not a server. Its id: ' + deployed.container.id
        sys.exit(1)

if deployed.isolatedClassLoader:
    booleanValueForIsolation = "true"
else:
    booleanValueForIsolation = "false"

if scope == 'cell':
    adminConfigCreate('MailProvider', AdminConfig.getid('/Cell:%s/' % cellName), '[[classpath "%s"] [name "%s"] [isolatedClassLoader "%s"] [nativepath ""] [description "%s"]]' % (deployed.classpath, deployed.providerName, booleanValueForIsolation, deployed.description))
    print 'Created a mail provider named: ' + deployed.providerName + ' on cell ' + cellName + ' now configuring...'
    AdminConfig.save()
    provider = AdminConfig.getid('/Cell:%s/MailProvider:%s/' % (cellName, deployed.providerName))
else:
    adminConfigCreate('MailProvider', AdminConfig.getid('/Cell:%s/Node:%s/Server:%s/' % (cellName, nodeName, serverName)), '[[classpath "%s"] [name "%s"] [isolatedClassLoader "%s"] [nativepath ""] [description "%s"]]' % (deployed.classpath, deployed.providerName, booleanValueForIsolation, deployed.description))
    print 'Created a mail provider named: ' + deployed.providerName + ' on server ' + serverName + ' now configuring...'
    provider = AdminConfig.getid('/Cell:%s/Node:%s/Server:%s/MailProvider:%s/' % (cellName, nodeName, serverName, deployed.providerName))

print 'provider: ' + provider
print '-------'
adminConfigCreate('ProtocolProvider', provider, '[[type STORE] [classname com.sun.mail.pop3.POP3Store] [protocol pop3]]')
adminConfigCreate('ProtocolProvider', provider, '[[type STORE] [classname com.sun.mail.pop3.POP3SSLStore] [protocol pop3s]]')
adminConfigCreate('ProtocolProvider', provider, '[[type STORE] [classname com.sun.mail.imap.IMAPStore] [protocol imap]]')
adminConfigCreate('ProtocolProvider', provider, '[[type STORE] [classname com.sun.mail.imap.IMAPSSLStore] [protocol imaps]]')
adminConfigCreate('ProtocolProvider', provider, '[[type TRANSPORT] [classname com.sun.mail.smtp.SMTPTransport] [protocol smtp]]')
adminConfigCreate('ProtocolProvider', provider, '[[type TRANSPORT] [classname com.sun.mail.smtp.SMTPSSLTransport] [protocol smtps]]')

print 'Mail Provider ready for use'