/*
 * @(#)WasClusterSteps.java     2 Oct 2011
 *
 * Copyright © 2010 Andrew Phillips.
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */
package com.xebialabs.deployit.community.wasext.task;

import static java.lang.String.format;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedResource;

public class DatasourceTasks {
    private static final String TEST_CONNECTION_SCRIPT_PROPERTY = "testConnectionScript";
    private static final String TEST_CONNECTION_ORDER_PROPERTY = "testConnectionOrder";

    public static void testConnection(ExtensibleDeployedResource datasource, DeploymentPlanningContext ctx) {
        ctx.addStep(new PythonDeploymentStep(
                datasource.<Integer>getProperty(TEST_CONNECTION_ORDER_PROPERTY), datasource.getContainer().getCell(), 
                datasource.<String>getProperty(TEST_CONNECTION_SCRIPT_PROPERTY), 
                ImmutableMap.<String, Object>of("deployed", datasource), 
                format("Test datasource connection to '%s'", datasource.getName())));
    }
}
