package com.xebialabs.deployit.community.wasext.planning;

import com.xebialabs.deployit.community.wasext.task.ManagedServerTasks;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;

public class StopAndStartColdDeploymentServers extends StopAndStartColdDeploymentContainers<ManagedServer> {

    public StopAndStartColdDeploymentServers() {
        super(ManagedServer.class);
    }

    @Contributor
    public static void stopAndStartClusters(Deltas deltas, DeploymentPlanningContext ctx) {
        StopAndStartColdDeploymentServers contributor = new StopAndStartColdDeploymentServers();
        contributor.stopAndStartContainers(deltas, ctx);
    }

    @Override
    protected void stop(ManagedServer container, DeploymentPlanningContext ctx) {
        ManagedServerTasks.stop(container, ctx);
    }

    @Override
    protected void start(ManagedServer container, DeploymentPlanningContext ctx) {
        ManagedServerTasks.start(container, ctx);
    }
}
