def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")        #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();            #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList
    
def getValueOfConfigRoot(cellName):
    varSubEntries = AdminConfig.list('VariableSubstitutionEntry') 
    allVarSubEntries = wsadminToList(varSubEntries)
    for entry in allVarSubEntries:
        varName = AdminConfig.showAttribute(entry, "symbolicName")
        if varName == 'USER_INSTALL_ROOT':
            varVal = AdminConfig.showAttribute(entry, "value")
            return varVal + '/config'

cellName = deployed.container.name
fileDir = deployed.keystoreFile.targetDirectory
fileName = deployed.keystoreFile.name
if hasattr(deployed.keystoreFile, 'targetFile') and deployed.keystoreFile.targetFile != None:
    fileName = deployed.keystoreFile.targetFile
fullPath = fileDir + '/' + fileName
if deployed.useRelativePath:
    configRoot = getValueOfConfigRoot(cellName)
    print 'derived config root: ' + configRoot
    if fullPath.find(configRoot) == 0:
        fullPath = '${CONFIG_ROOT}' + fullPath[len(configRoot):]
print 'using keystore file: ' + fullPath


AdminTask.createKeyStore('[-keyStoreName %s -scopeName (cell):%s -keyStoreDescription -keyStoreLocation %s -keyStorePassword %s -keyStorePasswordVerify %s -keyStoreType %s -keyStoreInitAtStartup false -keyStoreReadOnly false -keyStoreStashFile false -keyStoreUsage SSLKeys ]' % (deployed.keystoreName, cellName, fullPath, deployed.password, deployed.password, deployed.keystoreType))

print 'Created a ' + deployed.keystoreType + ' keystore on cell ' + cellName + ' named "' + deployed.keystoreName + '"'