/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.deployment.planning;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.community.wasext.util.Predicates;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.List;

public abstract class SingleTypeContributor<D extends Deployed<?, ?>> {
    protected final Predicate<Delta> isOfType;
    protected List<D> deployedsCreated;
    protected List<TypedDelta> deployedsModified;
    protected List<TypedDelta> deployedsNoop;
    protected List<D> deployedsRemoved;
    private final Function<Delta, TypedDelta> toTypedDelta = new Function<Delta, TypedDelta>(){

        public TypedDelta apply(Delta input) {
            return new TypedDelta(input);
        }
    };

    protected SingleTypeContributor(Class<? extends D> classOfDeployed) {
        this(Type.valueOf(classOfDeployed));
    }

    protected SingleTypeContributor(Type typeOfDeployed) {
        this.isOfType = Predicates.deltaOf(typeOfDeployed);
    }

    protected void filterDeltas(List<Delta> deltas) {
        this.deployedsCreated = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter(deltas, (Predicate)com.google.common.base.Predicates.and(this.isOfType, Predicates.operationIs(Operation.CREATE))), (Function)new Function<Delta, D>(this){

            public D apply(Delta input) {
                return input.getDeployed();
            }
        }));
        this.deployedsModified = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter(deltas, (Predicate)com.google.common.base.Predicates.and(this.isOfType, Predicates.operationIs(Operation.MODIFY))), this.toTypedDelta));
        this.deployedsNoop = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter(deltas, (Predicate)com.google.common.base.Predicates.and(this.isOfType, Predicates.operationIs(Operation.NOOP))), this.toTypedDelta));
        this.deployedsRemoved = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter(deltas, (Predicate)com.google.common.base.Predicates.and(this.isOfType, Predicates.operationIs(Operation.DESTROY))), (Function)new Function<Delta, D>(this){

            public D apply(Delta input) {
                return input.getPrevious();
            }
        }));
    }

    protected class TypedDelta
    implements Delta {
        private final Delta delegate;

        private TypedDelta(Delta delegate) {
            this.delegate = delegate;
        }

        public Operation getOperation() {
            return this.delegate.getOperation();
        }

        public D getPrevious() {
            return this.delegate.getPrevious();
        }

        public D getDeployed() {
            return this.delegate.getDeployed();
        }

        public List<String> getIntermediateCheckpoints() {
            return this.delegate.getIntermediateCheckpoints();
        }
    }
}

