containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find target container '%s' at containment path '%s'" % (deployed.container.name, deployed.container.containmentPath))
applicationServerIds = AdminConfig.list('ApplicationServer', containerId).splitlines()
if len(applicationServerIds) != 1:
    print "Expected exactly one ApplicationServer to exist in the scope of Server %s" % (deployed.container.name)
    sys.exit(1)

args = [['mode', deployed.mode]]

print "Creating Classloader %s for Server %s using args %s" % (deployed.name, deployed.container.name, args)
classloaderId = adminConfigCreate('Classloader', applicationServerIds[0], args)

for l in deployed.libraries:
    largs = [['libraryName', l], ['sharedClassloader', 'true']]
    print "Creating LibraryRef for Classloader %s using args %s" % (deployed.name, largs)
    adminConfigCreate('LibraryRef', classloaderId, largs)
