def discoverAndInspectMailProvidersInContainer(container, mpInspectCallback):
    print "Retrieving list of Mail Providers in container %s" % (container.name)
    mailproviders = AdminConfig.list('MailProvider').splitlines()
    for mp in mailproviders:
        if mp.find('Built-in Mail Provider(') != 1:
            print "Handling", mp
            dName = AdminConfig.showAttribute(mp, 'name')
            print "Discovered %s %s in container %s" % (prototype.type, dName, container.name)
            deployedId = container.id + '/' + dName
            discovered(deployedId, prototype.type)
            mpInspectCallback(deployedId, dName, mp, container)
            inspectedItem(deployedId)
        else:
            print "Skipping the handling of", mp, "as it is a build in mail provider"
            

def discoverAndInspectMailProviders(mpInspectCallback=None):
    if mpInspectCallback is None:
        mpInspectCallback = inspectMailProvider
    for c in findAllContainers(container):
        discoverAndInspectMailProvidersInContainer(c, mpInspectCallback)

def inspectMailProvider(deployedId, dsName, datasourceId, container):
    inspectedProperty(deployedId, 'providerName', AdminConfig.showAttribute(datasourceId, 'name'))
    inspectedProperty(deployedId, 'isolatedClassLoader', AdminConfig.showAttribute(datasourceId, 'isolatedClassLoader'))
    inspectedProperty(deployedId, 'classpath', AdminConfig.showAttribute(datasourceId, 'classpath'))
    inspectedProperty(deployedId, 'description', AdminConfig.showAttribute(datasourceId, 'description'))
    inspectedProperty(deployedId, 'scope', 'cell')

discoverAndInspectMailProviders()