
def printErrorAndExit(msg, exitCode = 1):
    print >> sys.stderr, msg
    sys.exit(exitCode)

def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")     #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();           #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList

def wsadminToMap(inStr):
    outMap = {}
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1].rstrip()
        if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
            inStr = inStr[1:-1].rstrip()
        else:
            return outMap
    else:
        return outMap
    tmpList = inStr.split("] [")
    for item in tmpList:
        parts = item.split(" ")
        if len(parts) == 1:
            outMap[parts[0]] = None
        elif len(parts) == 2:
            outMap[parts[0]] = parts[1]
        else:
            outMap[parts[0]] = ' '.join(parts[1:])
    return outMap

def convertTransportValue(transportValue):
    if transportValue == 'TCP/IP':
        return 'Never'
    if transportValue == 'SSL-Required':
        return 'Required'
    if transportValue == 'SSL-Supported':
        return 'Supported'

def getSecurityDomainArgs(securityDomainName):
    if not securityDomainName:
        return []
    return ['-securityDomainName', securityDomainName]

def getClientCertAuthArgs(clientCertAuth):
    return ['-clientCertAuth', clientCertAuth]

def getTransportLayerArgs(transport):
    return ['-transportLayer', convertTransportValue(transport)]

def getSslConfigurationArgs(sslSettingsCentrallyManaged):
    sslArgs = ['-sslConfiguration']
    if not sslSettingsCentrallyManaged:
        # NOTE: hardcoded to preconfigured SSL setting, so no custom SSL configuration
        sslArgs.append('CellDefaultSSLSettings')
    return sslArgs

def updateAuthMechanism(mechanism, add, authMechanisms):
    if add:
        if not mechanism in authMechanisms:
            authMechanisms.append(mechanism)
        return authMechanisms
    else:
        return filter(lambda m, mechanism=mechanism: m != mechanism, authMechanisms)

def getSupportedAuthMechanismArgs(supportedAuthMechanisms, basicAuthentication, ltpa, messageLevelAuth):
    if supportedAuthMechanisms != None and supportedAuthMechanisms.strip():
        authMechanisms = supportedAuthMechanisms.split("|")
    else:
        authMechanisms = []

    authMechanisms = updateAuthMechanism('BASICAUTH', basicAuthentication, authMechanisms)
    authMechanisms = updateAuthMechanism('LTPA', ltpa, authMechanisms)

    if authMechanisms:
        return ['-supportedAuthMechList', "|".join(authMechanisms)]
    else:
        if messageLevelAuth != 'Never':
            printErrorAndExit("Refusing to configure no message layer authentication mechanisms without setting message level authentication to 'Never'")
        return ['-supportedAuthMechList']

def getMessageLayerArgs(messageAuth):
    if messageAuth:
        return ['-messageLevelAuth', messageAuth]
    else:
        return []

def findSecurityDomain(securityDomainName):
    for sd in AdminConfig.list('SecurityDomain').split():
        name = AdminConfig.showAttribute(sd, 'name')
        if name == securityDomainName:
            return sd
    return None

def createSecurityDomain(securityDomainName):
    print "Creating Security Domain '%s'" % securityDomainName
    description = "%s created by Deployit" % securityDomainName
    AdminTask.createSecurityDomain(['-securityDomainName', securityDomainName, '-securityDomainDescription', description])
    # domain returned by AT.createSecurityDomain is not the actual security domain created.
    return findSecurityDomain(securityDomainName)

def mapResourceIfNecessary(resourceName, security, securityDomainName):
    mappings = AdminTask.listResourcesInSecurityDomain(['-securityDomainName', securityDomainName]).splitlines();
    print "Current mappings for security domain '%s': %s" % (securityDomainName, mappings)

    # ServerCluster is returned as Cluster in listResourcesInSecurityDomain
    resourceNameForCheck = resourceName.replace(':ServerCluster=', ':Cluster=')
    if not resourceNameForCheck in mappings:
        print "Mapping '%s' to '%s'" % (resourceName, securityDomainName)
        AdminTask.mapResourceToSecurityDomain(['-securityDomainName', securityDomainName, '-resourceName', resourceName])
    else:
        print "Mapping already exists: '%s' to '%s'" % (resourceName, securityDomainName)

def getResourceName(container):
    target = AdminConfig.getid(container.containmentPath)
    targetType = container.wasConfigIdType

    if targetType == 'Server':
        resourceName = 'Cell=%s:Node=%s:Server=%s' % (container.cellName, container.nodeName, container.name)
    elif targetType == 'Cell':
        resourceName = 'Cell=%s' % container.name
    elif targetType == 'ServerCluster':
        resourceName = 'Cell=%s:ServerCluster=%s' % (container.cellName, container.name)
    else:
        return None

    return resourceName

def hasDeprecatedServerLevelSecurity(deployed):
    deprecatedSecurity = AdminConfig.getid(deployed.container.containmentPath+'/Security:/')
    if deployed.container.wasConfigIdType == 'Server' and deprecatedSecurity:
        resourceName = getResourceName(deployed.container)
        newSecurityDomainName = 'securityDomainFor_%s' % deployed.container.name
        print """
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
Server '%s' has deprecated Server level 'Security' object:
 '%s'

This is not supported by this plugin.

You can migrate the Server level Security object to a SecurityDomain by invoking:

AdminTask.convertServerSecurityToSecurityDomain (['-serverResource', '%s',
                                                  '-securityDomain', '%s',
                                                  '-securityDomainDescription', 'Migrated Security object',
                                                  '-deleteServer', 'true' ])

Please check the documentation before use:

%s
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
""" % (deployed.container.name, deprecatedSecurity, resourceName, newSecurityDomainName, AdminTask.help('convertServerSecurityToSecurityDomain'))
        return 1
    else:
        return 0

def safeGet(map, prop, default = None):
    if map.has_key(prop):
        return map[prop]
    else:
        return default

if getVersion(deployed.container) == 'WAS_61':
    printErrorAndExit('CSIv2 is not supported via this plugin on WebSphere 6')

if deployed.createSecurityDomainIfNotFound and not deployed.securityDomainName:
    printErrorAndExit('createSecurityDomainIfNotFound=True but no securityDomainName specified')

inboundArgs = []
outboundArgs = []

security = None

if not deployed.securityDomainName:
    if deployed.container.wasConfigIdType != 'Cell':
        printErrorAndExit("This plugin only supports 'Security' objects at (global) Cell level")

    print "No Security Domain specified using Global Security"
    security = AdminConfig.getid("/Cell:%s/Security:/" % deployed.container.cellName)
    if not security:
        printErrorAndExit("No Security Domain specified and no Global Security present: Aborting")
else:
    security = findSecurityDomain(deployed.securityDomainName)
    if not security:
        if deployed.createSecurityDomainIfNotFound:
            security = createSecurityDomain(deployed.securityDomainName)
            if not security:
                printErrorAndExit("Failed to create Security Domain '%s': Aborting" % deployed.securityDomainName)
        else:
            printErrorAndExit("Security Domain '%s' not found and creation not requested: Aborting" % deployed.securityDomainName)

    # operate on the security domain, if not specified it will fall back to global security
    inboundArgs.extend(getSecurityDomainArgs(deployed.securityDomainName))
    outboundArgs.extend(getSecurityDomainArgs(deployed.securityDomainName))

if AdminConfig.getObjectType(security) == 'Security':
    print "Configuring CSIv2 on Global Security object"
else:
    print "Configuring CSIv2 on Security Domain '%s'" % deployed.securityDomainName

    if hasDeprecatedServerLevelSecurity(deployed):
        sys.exit(1)

    resourceName = getResourceName(deployed.container)
    if resourceName:
        mapResourceIfNecessary(resourceName, security, deployed.securityDomainName)
    else:
        printErrorAndExit("Unsupported targetType '%s' on container '%s': Aborting" % (deployed.container.wasConfigIdType, deployed.container.name))

csiiProps = wsadminToMap(AdminTask.getCSIInboundInfo(getSecurityDomainArgs(deployed.securityDomainName)))

inboundArgs.extend(getClientCertAuthArgs(deployed.inboundClientCertificateAuthentication))
inboundArgs.extend(getTransportLayerArgs(deployed.inboundTransport))
inboundArgs.extend(getSslConfigurationArgs(deployed.inboundSslSettingsCentrallyManaged))

inboundArgs.extend(getMessageLayerArgs(deployed.inboundMessageLevelAuth))
inboundArgs.extend(getSupportedAuthMechanismArgs(safeGet(csiiProps, 'supportedAuthMechanisms'),
                                                 deployed.inboundBasicAuthentication, deployed.inboundLTPA, deployed.inboundMessageLevelAuth))

print "CSIv2 inbound arguments: ", inboundArgs
AdminTask.configureCSIInbound(inboundArgs)

csioProps = wsadminToMap(AdminTask.getCSIOutboundInfo(getSecurityDomainArgs(deployed.securityDomainName)))

outboundArgs.extend(getClientCertAuthArgs(deployed.outboundClientCertificateAuthentication))
outboundArgs.extend(getTransportLayerArgs(deployed.outboundTransport))
outboundArgs.extend(getSslConfigurationArgs(deployed.outboundSslSettingsCentrallyManaged))

outboundArgs.extend(getMessageLayerArgs(deployed.outboundMessageLevelAuth))
outboundArgs.extend(getSupportedAuthMechanismArgs(safeGet(csioProps, 'supportedAuthMechanisms'),
                                                  deployed.outboundBasicAuthentication, deployed.outboundLTPA, deployed.outboundMessageLevelAuth))

print "CSIv2 outbound arguments: ", outboundArgs
AdminTask.configureCSIOutbound(outboundArgs)
