
def buildCipherString():
    cipherString = ""
    if deployed.sslRsaWithNullMd5:
        cipherString = cipherString + 'SSL_RSA_WITH_NULL_MD5 '
    if deployed.sslRsaWithNullSha:
        cipherString = cipherString + 'SSL_RSA_WITH_NULL_SHA '
    if deployed.sslRsaWithDesCbcSha:
        cipherString = cipherString + 'SSL_RSA_WITH_DES_CBC_SHA '
    if deployed.sslRsaFipsWithDesCbcSha:
        cipherString = cipherString + 'SSL_RSA_FIPS_WITH_DES_CBC_SHA '
    if deployed.sslDheRsaWithDesCbcSha:
        cipherString = cipherString + 'SSL_DHE_RSA_WITH_DES_CBC_SHA '
    if deployed.sslDheDssWithDesCbcSha:
        cipherString = cipherString + 'SSL_DHE_DSS_WITH_DES_CBC_SHA '
    if deployed.sslRsaExportWithRc440Md5:
        cipherString = cipherString + 'SSL_RSA_EXPORT_WITH_RC4_40_MD5 '
    if deployed.sslRsaExportWithDes40CbcSha:
        cipherString = cipherString + 'SSL_RSA_EXPORT_WITH_DES40_CBC_SHA '
    if deployed.sslDheRsaExportDes40CbcSha:
        cipherString = cipherString + 'SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA '
    if deployed.sslDheDssExportWithDes40CbcSha:
        cipherString = cipherString + 'SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA '
    if deployed.sslRsaWithRc4128Md5:
        cipherString = cipherString + 'SSL_RSA_WITH_RC4_128_MD5 '
    if deployed.sslRsaWithRc4128Sha:
        cipherString = cipherString + 'SSL_RSA_WITH_RC4_128_SHA '
    if deployed.sslRsaWithAes128cbcSha:
        cipherString = cipherString + 'SSL_RSA_WITH_AES_128_CBC_SHA '
    if deployed.sslDheRsaWithAes128CbcSha:
        cipherString = cipherString + 'SSL_DHE_RSA_WITH_AES_128_CBC_SHA '
    if deployed.sslDheDssWithAes128CbcSha:
        cipherString = cipherString + 'SSL_DHE_DSS_WITH_AES_128_CBC_SHA '
    if deployed.sslRsaWith3DesEdeCbcSha:
        cipherString = cipherString + 'SSL_RSA_WITH_3DES_EDE_CBC_SHA '
    if deployed.sslRsaFipsWith3DesEdeCbcSha:
        cipherString = cipherString + 'SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA '
    if deployed.sslDheRsaWith3DesEdeCbcSha:
        cipherString = cipherString + 'SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA '
    if deployed.sslDheDssWith3DesEdeCbcSha:
        cipherString = cipherString + 'SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA '
    if deployed.sslDheDssWithRc4128Sha:
        cipherString = cipherString + 'SSL_DHE_DSS_WITH_RC4_128_SHA '

    if cipherString != "":
        # strip last space
        cipherString = cipherString[:-1]
    return cipherString

cellName = deployed.container.name
keystoreName = deployed.keystore.keystoreName

clientAliasSet = hasattr(deployed, 'clientKeyAlias') and deployed.clientKeyAlias != None and deployed.clientKeyAlias != ''
serverAliasSet = hasattr(deployed, 'serverKeyAlias') and deployed.serverKeyAlias != None and deployed.serverKeyAlias != ''

if deployed.clientKeyAlias:
    print 'client alias is set'
else:
    print 'client alias not provided'
if deployed.serverKeyAlias:
    print 'server alias is set'
else:
    print 'server alias not provided'

if clientAliasSet and serverAliasSet:
    AdminTask.createSSLConfig('[-alias %s -type JSSE -scopeName (cell):%s -keyStoreName %s -keyStoreScopeName (cell):%s -trustStoreName CellDefaultKeyStore -trustStoreScopeName (cell):%s -serverKeyAlias %s -clientKeyAlias %s ]' % (deployed.sslConfigName, cellName, keystoreName, cellName, cellName, deployed.serverKeyAlias, deployed.clientKeyAlias))
elif clientAliasSet and not serverAliasSet:
    AdminTask.createSSLConfig('[-alias %s -type JSSE -scopeName (cell):%s -keyStoreName %s -keyStoreScopeName (cell):%s -trustStoreName CellDefaultKeyStore -trustStoreScopeName (cell):%s -clientKeyAlias %s ]' % (deployed.sslConfigName, cellName, keystoreName, cellName, cellName, deployed.clientKeyAlias))
elif not clientAliasSet and serverAliasSet:
    AdminTask.createSSLConfig('[-alias %s -type JSSE -scopeName (cell):%s -keyStoreName %s -keyStoreScopeName (cell):%s -trustStoreName CellDefaultKeyStore -trustStoreScopeName (cell):%s -serverKeyAlias %s ]' % (deployed.sslConfigName, cellName, keystoreName, cellName, cellName, deployed.serverKeyAlias))
elif not clientAliasSet and not serverAliasSet:
    AdminTask.createSSLConfig('[-alias %s -type JSSE -scopeName (cell):%s -keyStoreName %s -keyStoreScopeName (cell):%s -trustStoreName CellDefaultKeyStore -trustStoreScopeName (cell):%s ]' % (deployed.sslConfigName, cellName, keystoreName, cellName, cellName))

if deployed.clientAuthentication == 'None':
    authenticationSubstring = '-clientAuthentication false -clientAuthenticationSupported false'
elif deployed.clientAuthentication == 'Required':
    authenticationSubstring = '-clientAuthentication true'
elif deployed.clientAuthentication == 'Supported':
    authenticationSubstring = '-clientAuthentication false -clientAuthenticationSupported true'

print 'Created a SSL configuration named: "' + deployed.sslConfigName + '" on cell ' + cellName + '. It uses keystore ' + keystoreName
# We need a save before we can set the QoP (quality Of Protection)
AdminConfig.save()

print 'SSL configuration created, now configuring...'
ciphers = buildCipherString()
AdminTask.modifySSLConfig('[-alias %s -scopeName (cell):%s -keyStoreName %s -keyStoreScopeName (cell):%s -trustStoreName CellDefaultKeyStore -trustStoreScopeName (cell):%s -jsseProvider IBMJSSE2 -sslProtocol SSL_TLS %s -securityLevel CUSTOM -enabledCiphers "%s"]' % (deployed.sslConfigName, cellName, keystoreName, cellName, cellName, authenticationSubstring, ciphers))

print 'SSL configuration configured.'