def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")        #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();            #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList

def findMemberOfClusterByServerName(members, servername):
    allMembers = wsadminToList(members)
    for member in allMembers:
        membername = AdminConfig.showAttribute(member, 'memberName')
        if membername == servername:
            return member
    return None

def verifySchedulerContainerVersusServerContainer(deployed, schedulerContainerName, schedulerScope, server, findMemberOfClusterByServerName):
    if schedulerScope == 'cell':
        schedulerCell = AdminConfig.getid('/Cell:%s' % schedulerContainerName)
        serverCellName = deployed.container.node.cell.name
        serverCell = AdminConfig.getid('/Cell:%s' % serverCellName)
        if serverCell != schedulerCell:
            print 'ERROR you can not associated a Scheduler deployed on cell ' + schedulerContainerName + ' to a server on cell ' + serverCellName
            sys.exit(1)
    elif schedulerScope == 'cluster':
        clusterName = deployed.EJBTimerServiceScheduler.container.name
        cluster = AdminConfig.getid('/ServerCluster:%s' % clusterName)
        members = AdminConfig.showAttribute(cluster, 'members')
        index = server.find('(')
        serverName = server[0:index]
        member = findMemberOfClusterByServerName(members, serverName)
        if member is None:
            print 'ERROR you can not associate a Scheduler deployed on cluster ' + schedulerContainerName + ' to server ' + serverName + ' as this server is not a member of that cluster'
            sys.exit(1)
        
        
def configureServer(container, deployed, verifySchedulerContainerVersusServerContainer, findMemberOfClusterByServerName):
    # can't define these at the top level, for some reason
    def modifyServerPort(server, portName, host, port):
        def toConfigIdList(spaceSeparatedIdList):
            # input format '[id id id ...]'
            # strings.strip(chars) not available in Python 2.1
            return spaceSeparatedIdList.replace('[', '').replace(']', '').split(' ')

        node = AdminConfig.getid('/Node:%s/' % (server.nodeName))
        for serverEntry in AdminConfig.list('ServerEntry', node).splitlines():
            if server.name == AdminConfig.showAttribute(serverEntry, 'serverName'):
                for namedEndPoint in toConfigIdList(AdminConfig.showAttribute(serverEntry, 'specialEndpoints')):
                    if portName == AdminConfig.showAttribute(namedEndPoint, 'endPointName'):
                        adminConfigModify(AdminConfig.showAttribute(namedEndPoint, 'endPoint'), [['host', host], ['port', port]])
                        return True
        return False

    print "Configuring server '%s'" % (container.name)
    server = AdminConfig.getid('/Node:%s/Server:%s' % (container.nodeName, container.name))

    jvmConfig = AdminConfig.list("JavaVirtualMachine", server)
    javaProcessDefConfig = AdminConfig.list('JavaProcessDef', server)
    processExecutionConfig = AdminConfig.list('ProcessExecution', javaProcessDefConfig)
    outputRedirectConfig = AdminConfig.list('OutputRedirect', javaProcessDefConfig)
    outputStreamRedirectConfig = AdminConfig.showAttribute(server, 'outputStreamRedirect')
    errorStreamRedirectConfig = AdminConfig.showAttribute(server, 'errorStreamRedirect')
    applicationServerConfig = AdminConfig.list('ApplicationServer', server)
    webContainerConfig = AdminConfig.list('WebContainer', server)
    sessionManagerConfig = AdminConfig.list('SessionManager', server)
    tuningParamsConfig = AdminConfig.list('TuningParams', sessionManagerConfig)
    defaultCookieSettingsConfig = AdminConfig.list('Cookie', sessionManagerConfig)
    ejbContainerConfig = AdminConfig.list('EJBContainer', server)
    transactionServiceConfig = AdminConfig.list('TransactionService', server)
    monitoringPolicy = AdminConfig.list('MonitoringPolicy', server)
    pmiService = AdminConfig.list('PMIService', server)
    haManagerService = AdminConfig.list('HAManagerService', server)

    if hasattr(deployed,'JavaVirtualMachine'):
        allArgs = toAdminConfigArgs(deployed.JavaVirtualMachine.getExposedProperties(True))

        # Append to old JVM arguments     
        oldJvmArgs = AdminConfig.showAttribute(jvmConfig, 'genericJvmArguments')
        if deployed.appendGenericJvmArguments:
            for arg in allArgs:
                if arg[0] == 'genericJvmArguments':
                    value = arg[1]
                    if oldJvmArgs.find(value) == -1:
                        arg[1] = oldJvmArgs + ' ' + value
                    else: 
                        arg[1] = oldJvmArgs
        
        print 'Modifying JavaVirtualMachine parameters %s ' % (allArgs)
        adminConfigModify(jvmConfig, allArgs)

    if hasattr(deployed,'jvmCustomProperties'):
        print 'Setting JavaVirtualMachine properties'

        # Get existing values from server
        existing = {}
        environment = AdminConfig.showAttribute(jvmConfig, 'systemProperties')
        if environment != "[]":
            entries = environment[1:-1].split()
            for entry in entries:
                name = AdminConfig.showAttribute(entry, 'name')
                existing[name] = entry

        # Add or modify entries
        for property in deployed.jvmCustomProperties:
          values = property.split(deployed.valueSeparator, 1)
          if (len(values) == 2):
            key = values[0]
            value = values[1]
            attr = [["name", key], ["value", value]]
            if existing.has_key(key):
                print 'Modifying JVM custom property %s = %s' % (key,value)
                adminConfigModify(existing[key], attr)
            else:
                print 'Adding JVM custom property %s = %s' % (key,value)
                adminConfigCreate("Property", jvmConfig, attr)
          else:
            print "ERROR: Invalid JVM custom property '%s'. Expected two values (name and the value) separated by '%s'" % (variable, separator)
            sys.exit(1)

    if hasattr(deployed, 'Ports'):
        print 'Modifying ports'
        for name, hostAndPort in deployed.Ports.ports.items():
            hostPort = hostAndPort.split(':')
            print "Setting port '%s' to '%s:%s'" % (name, hostPort[0], hostPort[1])
            modifyServerPort(container, name, hostPort[0], hostPort[1])

    if hasattr(deployed,'JavaProcessDef'):
        print 'Modifying JavaProcessDef parameters'
        adminConfigModify(javaProcessDefConfig,toAdminConfigArgs(deployed.JavaProcessDef.getExposedProperties(True)))

    if hasattr(deployed, 'JavaProcessDefEnvironmentEntries'):
        print 'Setting JavaProcessDef Environment Entries'
        
        # Get existing values from server
        existing = {}
        environment = AdminConfig.showAttribute(javaProcessDefConfig, 'environment')
        if environment != "[]":
            entries = environment[1:-1].split()
            for entry in entries:
                name = AdminConfig.showAttribute(entry, 'name')
                existing[name] = entry

        # Add or modify entries
        for key, value in deployed.JavaProcessDefEnvironmentEntries.items():
            attr = [["name", key], ["value", value]]
            if existing.has_key(key):
                print 'Modifying Environment Entry %s = %s' % (key,value)
                adminConfigModify(existing[key], attr)
            else:
                print 'Adding Environment Entry %s = %s' % (key,value)
                adminConfigCreate("Property", javaProcessDefConfig, attr)
        
    if hasattr(deployed,'ProcessExecution'):
        print 'Modifying ProcessExecution parameters'
        adminConfigModify(processExecutionConfig, toAdminConfigArgs(deployed.ProcessExecution.getExposedProperties(True)))

    if hasattr(deployed,'OutputRedirect'):
        print 'Modifying OutputRedirect parameters'
        adminConfigModify(outputRedirectConfig, toAdminConfigArgs(deployed.OutputRedirect.getExposedProperties(True)))

    if hasattr(deployed,'OutputStreamRedirect'):
        print 'Modifying OutputStreamRedirect parameters'
        adminConfigModify(outputStreamRedirectConfig, toAdminConfigArgs(deployed.OutputStreamRedirect.getExposedProperties(True)))

    if hasattr(deployed,'ErrorStreamRedirect'):
        print 'Modifying ErrorStreamRedirect parameters'
        adminConfigModify(errorStreamRedirectConfig, toAdminConfigArgs(deployed.ErrorStreamRedirect.getExposedProperties(True)))

    if hasattr(deployed,'ApplicationServer'):
        print 'Modifying ApplicationServer parameters %s ' % (toAdminConfigArgs(deployed.ApplicationServer.getExposedProperties(True)))
        adminConfigModify(applicationServerConfig, toAdminConfigArgs(deployed.ApplicationServer.getExposedProperties(True)))

    if hasattr(deployed,'WebContainer'):
        args = toAdminConfigArgs(deployed.WebContainer.getExposedProperties(True))
        print 'Modifying WebContainer parameters %s' % (args)
        adminConfigModify(webContainerConfig, args)

    if hasattr(deployed,'WebContainerSessionManager'):
        sessionPersistenceMode = deployed.WebContainerSessionManager.sessionPersistenceMode
        if sessionPersistenceMode != "":
            webContainerSessionManager = AdminConfig.list('SessionManager', webContainerConfig)
            args = toAdminConfigArgs(deployed.WebContainerSessionManager.getExposedProperties(True))
            print 'Modifying WebContainer session manager', args
            adminConfigModify(webContainerSessionManager, args)
            if sessionPersistenceMode == "DATABASE" and hasattr(deployed,'WebContainerSessionDbPersistence'):
                args = toAdminConfigArgs(deployed.WebContainerSessionDbPersistence.getExposedProperties(True))
                print 'Modifying WebContainer session database persistence', args
                sessionDbPersistenceParams = AdminConfig.list('SessionDatabasePersistence', webContainerSessionManager)
                adminConfigModify(sessionDbPersistenceParams, args)

    if hasattr(deployed,'WebContainerProperties'):
        print 'Setting WebContainer Custom Properties'
        adminConfigModify(webContainerConfig, [['properties', []]])
        for key, value in deployed.WebContainerProperties.custom.items():
            attr = [["name", key], ["value", value]]
            print 'Adding Custom Property %s = %s' % (key,value)
            adminConfigCreate("Property", webContainerConfig, attr)

    if hasattr(deployed,'SessionManager'):
        print 'Modifying SessionManager parameters'
        adminConfigModify(sessionManagerConfig, toAdminConfigArgs(deployed.SessionManager.getExposedProperties(True)))

    if hasattr(deployed,'TuningParams'):
        print 'Modifying TuningParams parameters'
        adminConfigModify(tuningParamsConfig, toAdminConfigArgs(deployed.TuningParams.getExposedProperties(True)))

    if hasattr(deployed, 'DefaultCookieSettings'):
        print 'Modifying DefaultCookieSetings parameters'
        adminConfigModify(defaultCookieSettingsConfig, toAdminConfigArgs(deployed.DefaultCookieSettings.getExposedProperties(True)))

    if hasattr(deployed,'EJBContainer'):
        args = toAdminConfigArgs(deployed.EJBContainer.getExposedProperties(True))
        print 'Modifying EJBContainer parameters %s' % (args)
        adminConfigModify(ejbContainerConfig, args)

    if hasattr(deployed,'TransactionService'):
        print 'Modifying TransactionService parameters'
        adminConfigModify(transactionServiceConfig, toAdminConfigArgs(deployed.TransactionService.getExposedProperties(True)))

    if hasattr(deployed,'MonitoringPolicy'):
        print 'Modifying MonitoringPolicy parameters'
        adminConfigModify(monitoringPolicy, toAdminConfigArgs(deployed.MonitoringPolicy.getExposedProperties(True)))
        
    if hasattr(deployed, 'PMIService'):
        print 'Modifying PMI Service parameters'
        adminConfigModify(pmiService, toAdminConfigArgs(deployed.PMIService.getExposedProperties(True)))
        pmiRootModule = AdminConfig.list('PMIModule', pmiService)
        pmiModules = {}
        for moduleId in wsadminToList(AdminConfig.showAttribute(pmiRootModule, "pmimodules")):
            pmiModules[AdminConfig.showAttribute(moduleId, 'moduleName')] = moduleId
        if deployed.PMIService.statisticSet == 'custom':
            for moduleName, metrics in deployed.PMICustomModuleMetrics.items():
                if not moduleName in pmiModules.keys():
                    print "WARN: No module named '%s' found in %s. Ignoring metrics settings '%s' for '%s'" % (moduleName, pmiModules.keys(), metrics, moduleName)
                else:
                    print "Setting metrics for '%s' to '%s'" % (moduleName, metrics)
                    adminConfigModify(pmiModules[moduleName], [["enable", metrics]])

    if hasattr(deployed, 'EJBTimerServiceScheduler') and deployed.EJBTimerServiceScheduler != None:
        timerSettings = AdminConfig.showAttribute(ejbContainerConfig, 'timerSettings')
        schedulerContainerName = deployed.EJBTimerServiceScheduler.container.name
        schedulerScope = deployed.EJBTimerServiceScheduler.scope
        print 'Verifying that this scheduler is on a cluster or cell that this server is on too...'
        verifySchedulerContainerVersusServerContainer(deployed, schedulerContainerName, schedulerScope, server, findMemberOfClusterByServerName)
        print 'Verification was ok. Modifying EJB Timer Service parameters'
        adminConfigModify(timerSettings, '[[schedulerJNDIName "%s"]]' % deployed.EJBTimerServiceScheduler.jndiName)
        
    if hasattr(deployed,'HAManagerService'):
        print 'Modifying Core Group Service Service parameters'
        adminConfigModify(haManagerService, toAdminConfigArgs(deployed.HAManagerService.getExposedProperties(True)))

containerConfigType = deployed.container.wasConfigIdType
if containerConfigType == 'ServerCluster':
    for server in deployed.container.servers:
        configureServer(server, deployed, verifySchedulerContainerVersusServerContainer, findMemberOfClusterByServerName)
elif containerConfigType == 'Server':
    configureServer(deployed.container, deployed, verifySchedulerContainerVersusServerContainer, findMemberOfClusterByServerName)
else:
    print "Cannot modify settings on container of WebSphere config type '%s'. Nothing to do." % (containerConfigType)