def emptyListToEmpty(string):
  if string == '[]':
    return ''
  else:
    return string

def discoverAndInspectJdbcProvidersInContainer(container, jpInspectCallback):
    print "Retrieving list of JDBC Providers in '%s'" % (container.name)
    providerContainmentPath = "%s/JDBCProvider:/" % (container.containmentPath)
    jdbcProviders = AdminConfig.getid(providerContainmentPath).splitlines()
    for jdbcProvider in jdbcProviders:
        if jdbcProvider.find('#builtin_jdbcprovider') == -1:
            print "Handling '%s'" % (jdbcProvider)
            providerName = AdminConfig.showAttribute(jdbcProvider, 'name')
            print "Discovered %s '%s' in '%s'" % (prototype.type, providerName, container.name)
            deployedId = container.id + '/' + providerName
            discovered(deployedId, prototype.type)
            jpInspectCallback(deployedId, providerName, jdbcProvider, container)
            inspectedItem(deployedId)
        else:
            print "Skipping built-in JDBC provider '%s'" % (jdbcProvider)

def discoverAndInspectJdbcProviders(jpInspectCallback = None):
    if jpInspectCallback is None:
        jpInspectCallback = inspectJdbcProvider
    for c in findAllContainers(container):
        discoverAndInspectJdbcProvidersInContainer(c, jpInspectCallback)

def inspectJdbcProvider(deployedId, dsName, providerId, container):
    inspectedProperty(deployedId, 'providerType', AdminConfig.showAttribute(providerId, 'providerType'))
    inspectedProperty(deployedId, 'implementationClassName', AdminConfig.showAttribute(providerId, 'implementationClassName'))
    inspectedProperty(deployedId, 'classpath', AdminConfig.showAttribute(providerId, 'classpath'))
    inspectedProperty(deployedId, 'description', AdminConfig.showAttribute(providerId, 'description'))
    inspectedProperty(deployedId, 'nativepath', emptyListToEmpty(AdminConfig.showAttribute(providerId, 'nativepath')))

discoverAndInspectJdbcProviders()