def getVersion(wasContainer):
  if hasattr(wasContainer, 'node'):
    return wasContainer.node.cell.version
  if hasattr(wasContainer, 'cell'):
    return wasContainer.cell.version
  else:
    return wasContainer.version

containerId = AdminConfig.getid(deployed.container.containmentPath)

exposedProperties = deployed.getExposedProperties(True)
if getVersion(deployed.container) == 'WAS_61':
  if 'isolatedClassLoader' in exposedProperties.keys():
    print "WARN: Ignoring property 'isolatedClassLoader' which is not supported on WAS 6.1"
    del exposedProperties['isolatedClassLoader']

args = toAdminConfigArgs(exposedProperties)
print "Creating JDBC Provider for '%s' with args %s" % (containerId, args)
adminConfigCreate('JDBCProvider', containerId, args)

