/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step.rule;

import com.google.common.collect.Collections2;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.step.rule.ResultCheck;
import com.xebialabs.deployit.plugin.cloud.util.CiFilters;
import java.util.Collection;
import java.util.List;

public class SingleEnvCheck
implements ResultCheck {
    @Override
    public void check(List<? extends ConfigurationItem> cis) throws ResultCheck.Failed {
        Collection cloudEnvs = Collections2.filter(cis, CiFilters.CloudEnvironments);
        if (cloudEnvs.size() != 1) {
            String errorPattern = "There should be exactly one CI of type %s.%s, %s found.";
            throw new ResultCheck.Failed(String.format(errorPattern, CiFilters.cloudEnvType.getPrefix(), CiFilters.cloudEnvType.getName(), cloudEnvs.size()));
        }
    }
}

