/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.step.ValidateDescriptorStep;
import com.xebialabs.deployit.plugin.cloud.step.rule.NullCheck;
import com.xebialabs.deployit.plugin.cloud.util.CiUtils;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import freemarker.template.TemplateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ValidateHostDescriptorStep
extends ValidateDescriptorStep {
    public ConfigurationItem hostTemplate;

    public ValidateHostDescriptorStep(String descriptorTemplate, BaseHostTemplate hostTemplate) {
        super(descriptorTemplate, hostTemplate.getName(), new NullCheck());
        this.hostTemplate = hostTemplate;
        this.scope.put("hostsPath", "Infrastructure/exampleHostsLocation");
        this.scope.put("hostTemplate", hostTemplate);
        this.scope.put("cloudId", "exampleCloudId");
        this.scope.put("hostAddress", UUID.randomUUID() + ".cloud.example.com");
    }

    @Override
    protected String resolveTemplate(String tpl, Map<Object, Object> initialScope, ExecutionContext ctx) throws TemplateException {
        return this.descriptorResolver.resolve(tpl, initialScope);
    }

    @Override
    protected List<ConfigurationItem> parseCis(String tpl, ExecutionContext ctx) {
        List<ConfigurationItem> parsedCis = this.ciParser.fromString(tpl, ctx.getRepository());
        ArrayList<ConfigurationItem> oldValue = ContextHelper.wrapped(ctx).safeGet(ContextAttribute.PARSED_CIS, new ArrayList());
        oldValue.addAll(parsedCis);
        return parsedCis;
    }

    @Override
    protected void outputDescriptor(String descriptorTemplate, Map<Object, Object> scope, ExecutionContext ctx) throws Exception {
        HashMap<Object, Object> copiedScope = new HashMap<Object, Object>(scope);
        for (Map.Entry e : copiedScope.entrySet()) {
            if (!(e.getValue() instanceof ConfigurationItem)) continue;
            copiedScope.put(e.getKey(), CiUtils.securePasswords((ConfigurationItem)e.getValue()));
        }
        ctx.logOutput(this.resolveTemplate(descriptorTemplate, copiedScope, ctx));
    }
}

