/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ws.Argument;
import com.vmware.vim25.ws.SoapFaultException;
import com.vmware.vim25.ws.XmlGen;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class WSClient {
    private static final String SOAP_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>";
    private static final String SOAP_END = "</soapenv:Body></soapenv:Envelope>";
    private static final String SOAP_ACTION_HEADER = "SOAPAction";
    private static final String SOAP_ACTION_V40 = "urn:vim25/4.0";
    private static final String SOAP_ACTION_V41 = "urn:vim25/4.1";
    private static final String SOAP_ACTION_V50 = "urn:vim25/5.0";
    private static final String SOAP_ACTION_V51 = "urn:vim25/5.1";
    private URL baseUrl = null;
    private String cookie = null;
    private String vimNameSpace = null;
    private String soapAction = null;
    private int connectTimeout = 0;
    private int readTimeout = 0;

    public WSClient(String serverUrl) throws MalformedURLException {
        this(serverUrl, true);
    }

    public WSClient(String serverUrl, boolean ignoreCert) throws MalformedURLException {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        this.baseUrl = new URL(serverUrl);
        if (ignoreCert) {
            try {
                WSClient.trustAllHttpsCertificates();
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object invoke(ManagedObjectReference mor, String methodName, Argument[] paras, String returnType) throws IOException {
        Argument[] fullParas = new Argument[paras.length + 1];
        fullParas[0] = new Argument("_this", "ManagedObjectReference", mor);
        System.arraycopy(paras, 0, fullParas, 1, paras.length);
        return this.invoke(methodName, fullParas, returnType);
    }

    public Object invoke(String methodName, Argument[] paras, String returnType) throws RemoteException {
        Element root = this.invoke(methodName, paras);
        Element body = (Element)root.elements().get(0);
        Element resp = (Element)body.elements().get(0);
        if (resp.getName().indexOf("Fault") != -1) {
            SoapFaultException sfe = null;
            try {
                sfe = XmlGen.parseSoapFault(resp);
            }
            catch (Exception e) {
                throw new RemoteException("Exception in WSClient.invoke:", e);
            }
            if (sfe != null && sfe.detail != null) {
                throw (RemoteException)sfe.detail;
            }
            throw sfe;
        }
        if (returnType != null) {
            try {
                return XmlGen.fromXML(returnType, resp);
            }
            catch (Exception e) {
                throw new RemoteException("Exception in WSClient.invoke:", e);
            }
        }
        return null;
    }

    public Element invoke(String methodName, Argument[] paras) throws RemoteException {
        String soapMsg = this.createSoapMessage(methodName, paras);
        Element root = null;
        InputStream is = null;
        try {
            try {
                is = this.post(soapMsg);
                SAXReader reader = new SAXReader();
                Document doc = reader.read(is);
                root = doc.getRootElement();
            }
            catch (Exception e) {
                throw new RemoteException("VI SDK invoke exception:" + e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return root;
    }

    public StringBuffer invokeAsString(String methodName, Argument[] paras) throws RemoteException {
        String soapMsg = this.createSoapMessage(methodName, paras);
        try {
            InputStream is = this.post(soapMsg);
            return this.readStream(is);
        }
        catch (Exception e) {
            throw new RemoteException("VI SDK invoke exception:" + e);
        }
    }

    private String createSoapMessage(String methodName, Argument[] paras) {
        StringBuffer sb = new StringBuffer();
        sb.append(SOAP_HEADER);
        sb.append("<" + methodName + this.vimNameSpace);
        int i = 0;
        while (i < paras.length) {
            String key = paras[i].getName();
            String type = paras[i].getType();
            Object obj = paras[i].getValue();
            sb.append(XmlGen.toXML(key, type, obj));
            ++i;
        }
        sb.append("</" + methodName + ">");
        sb.append(SOAP_END);
        return sb.toString();
    }

    public InputStream post(String soapMsg) throws IOException {
        InputStream is;
        HttpURLConnection postCon = (HttpURLConnection)this.baseUrl.openConnection();
        if (this.connectTimeout > 0) {
            postCon.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            postCon.setReadTimeout(this.readTimeout);
        }
        try {
            postCon.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        postCon.setDoOutput(true);
        postCon.setDoInput(true);
        postCon.setRequestProperty(SOAP_ACTION_HEADER, this.soapAction);
        postCon.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        if (this.cookie != null) {
            postCon.setRequestProperty("Cookie", this.cookie);
        }
        OutputStream os = postCon.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(os, "UTF8");
        out.write(soapMsg);
        out.close();
        try {
            is = postCon.getInputStream();
        }
        catch (IOException ioe) {
            is = postCon.getErrorStream();
        }
        if (this.cookie == null) {
            this.cookie = postCon.getHeaderField("Set-Cookie");
        }
        return is;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getVimNameSpace() {
        return this.vimNameSpace;
    }

    public void setVimNameSpace(String vimNameSpace) {
        this.vimNameSpace = vimNameSpace;
    }

    public void setConnectTimeout(int timeoutMilliSec) {
        this.connectTimeout = timeoutMilliSec;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeoutMilliSec) {
        this.readTimeout = timeoutMilliSec;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setSoapActionOnApiVersion(String apiVersion) {
        this.soapAction = "4.0".equals(apiVersion) ? SOAP_ACTION_V40 : ("4.1".equals(apiVersion) ? SOAP_ACTION_V41 : ("5.0".equals(apiVersion) ? SOAP_ACTION_V50 : ("5.1".equals(apiVersion) ? SOAP_ACTION_V51 : SOAP_ACTION_V51)));
    }

    private StringBuffer readStream(InputStream is) throws IOException {
        String lineStr;
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((lineStr = in.readLine()) != null) {
            sb.append(lineStr);
        }
        in.close();
        return sb;
    }

    private static void trustAllHttpsCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

