/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.vsphere.steps;

import com.google.common.base.Preconditions;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.mo.Task;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.Retrier;
import com.xebialabs.deployit.plugin.cloud.vsphere.access.VsphereAdapter;
import com.xebialabs.deployit.plugin.cloud.vsphere.ci.HostTemplate;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.Callable;

public class WaitForVsphereTasksStep
implements Step {
    private VsphereAdapter adapter;
    private HostTemplate template;

    public WaitForVsphereTasksStep(HostTemplate template, VsphereAdapter adapter) {
        this.adapter = adapter;
        this.template = template;
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Wait for vSphere tasks to complete";
    }

    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        final List startedTasks = (List)Preconditions.checkNotNull((Object)((List)ctx.getAttribute(ContextAttribute.STARTED_TASKS.name())));
        ctx.logOutput(startedTasks.size() + " vSphere task(s) were started earlier.");
        if (startedTasks.isEmpty()) {
            return StepExitCode.SUCCESS;
        }
        for (String t : startedTasks) {
            final Task task = this.adapter.getTask(t);
            Boolean ok = (Boolean)new Retrier((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    WaitForVsphereTasksStep.this.printTasksStatus(ctx, startedTasks);
                    if (task.getTaskInfo().getState() == TaskInfoState.success) {
                        return true;
                    }
                    if (task.getTaskInfo().isCancelled()) {
                        ctx.logError("The task has been cancelled");
                        return false;
                    }
                    if (task.getTaskInfo().getState() == TaskInfoState.error) {
                        ctx.logError("There was and error during the task execution : " + task.getTaskInfo().getError().getLocalizedMessage());
                        return false;
                    }
                    throw new IllegalStateException("Task is in state " + task.getTaskInfo().getState() + ". Waiting.");
                }
            }).retryFor(this.template.getBootTimeout(), this.template.getRetryDelay());
            if (ok.booleanValue()) continue;
            return StepExitCode.FAIL;
        }
        ctx.setAttribute(ContextAttribute.STARTED_TASKS.name(), null);
        return StepExitCode.SUCCESS;
    }

    private void printTasksStatus(ExecutionContext ctx, List<String> tasks) throws RemoteException {
        for (String taskId : tasks) {
            TaskInfo taskInfo = this.adapter.getTask(taskId).getTaskInfo();
            TaskInfoState state = taskInfo.getState();
            int p = state == TaskInfoState.success ? 100 : (taskInfo.getProgress() == null ? 0 : taskInfo.getProgress());
            ctx.logOutput("Task progress of " + taskId + ": " + p + "%");
        }
    }
}

