package com.xebialabs.deployit.plugin.cloud.vsphere.steps;

import java.net.URL;
import com.vmware.vim25.mo.ServiceInstance;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.vsphere.ci.Credentials;

public class ValidateVSphereCredentialsStep implements Step {

    private Credentials credentials;

    public ValidateVSphereCredentialsStep(final Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER;
    }

    @Override
    public String getDescription() {
        return "Validate vSphere credentials for " + credentials.getUrl();
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        ctx.logOutput("Accessing " + credentials.getUrl());
        ServiceInstance si = new ServiceInstance(new URL(credentials.getUrl()), credentials.getUsername(), credentials.getPassword(), true);

        ctx.logOutput("OS type: " + si.getAboutInfo().getOsType());
        ctx.logOutput("API type: " + si.getAboutInfo().getApiType());
        ctx.logOutput("API version: " + si.getAboutInfo().getApiVersion());
        ctx.logOutput("Server time: " + si.getServerClock().getTime().toString());
        return StepExitCode.SUCCESS;
    }
}
