package com.xebialabs.deployit.plugin.trigger;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

@SuppressWarnings("serial")
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, description = "Defines actions to executed for the specified state transition of a Step.")
@TriggerValidator
public class StepTrigger extends Trigger<StepState> {

    @Property(defaultValue = "ANY", description = "Trigger actions when the Step transitions from this state.")
    private StepState fromState = StepState.ANY;

    @Property(description = "Trigger actions when the Step transitions to this state.")
    private StepState toState;

    @Override
    public StepState getFromState() {
        return fromState;
    }

    @Override
    public StepState getToState() {
        return toState;
    }

    public void setFromState(StepState fromState) {
        this.fromState = fromState;
    }

    public void setToState(StepState toState) {
        this.toState = toState;
    }
}
