/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.trigger;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.plugin.trigger.TriggerState;
import java.util.Set;

public enum TaskState implements TriggerState<TaskExecutionState>
{
    ANY(null, null),
    QUEUED(TaskExecutionState.QUEUED, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.EXECUTING})),
    PENDING(TaskExecutionState.PENDING, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.QUEUED, TaskExecutionState.SCHEDULED})),
    EXECUTING(TaskExecutionState.EXECUTING, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.EXECUTED, TaskExecutionState.FAILING, TaskExecutionState.STOPPING, TaskExecutionState.ABORTING, TaskExecutionState.FAILED, TaskExecutionState.STOPPED, TaskExecutionState.ABORTED})),
    DONE(TaskExecutionState.DONE, Sets.newHashSet()),
    STOPPED(TaskExecutionState.STOPPED, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.SCHEDULED, TaskExecutionState.CANCELLED, TaskExecutionState.QUEUED})),
    EXECUTED(TaskExecutionState.EXECUTED, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.DONE})),
    CANCELLED(TaskExecutionState.CANCELLED, Sets.newHashSet()),
    FAILING(TaskExecutionState.FAILING, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.FAILED, TaskExecutionState.ABORTING})),
    FAILED(TaskExecutionState.FAILED, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.SCHEDULED, TaskExecutionState.CANCELLED, TaskExecutionState.QUEUED})),
    STOPPING(TaskExecutionState.STOPPING, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.STOPPED, TaskExecutionState.ABORTING})),
    ABORTING(TaskExecutionState.ABORTING, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.ABORTED})),
    ABORTED(TaskExecutionState.ABORTED, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.SCHEDULED, TaskExecutionState.CANCELLED, TaskExecutionState.QUEUED})),
    SCHEDULED(TaskExecutionState.SCHEDULED, Sets.newHashSet((Object[])new TaskExecutionState[]{TaskExecutionState.QUEUED, TaskExecutionState.SCHEDULED}));

    private TaskExecutionState taskExecutionState;
    private Set<TaskExecutionState> validToTransition;

    private TaskState(TaskExecutionState taskExecutionState, Set<TaskExecutionState> validToTransition) {
        this.taskExecutionState = taskExecutionState;
        this.validToTransition = validToTransition;
    }

    @Override
    public boolean equivalentTo(TaskExecutionState spiState) {
        if (spiState == null) {
            return false;
        }
        return this.taskExecutionState == null || this.taskExecutionState == spiState;
    }

    public boolean isValidTransition(TaskState toState) {
        if (this.taskExecutionState == null || toState.taskExecutionState == null) {
            return true;
        }
        return this.validToTransition.contains(toState.taskExecutionState);
    }
}

