/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.processor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextElement;
import java.util.List;

public class Utils {
    public static final Type CONTEXT_ELEMENT_TYPE = Type.valueOf(ContextElement.class);

    public static Iterable<AbstractDeployed<?>> findDeployedsTargetedToContainer(List<Delta> list, Type type) {
        Iterable iterable = Iterables.filter(list, (Predicate)DeltasTargetedToContainerFilter.filterAllOperationsBesidesModifyOps(type));
        Iterable iterable2 = Iterables.filter(list, (Predicate)DeltasTargetedToContainerFilter.filterOnlyModifyOpsAndPreviousDeployed(type));
        Iterable iterable3 = Iterables.filter(list, (Predicate)DeltasTargetedToContainerFilter.filterOnlyModifyOpsAndCurrentDeployed(type));
        Iterable iterable4 = Iterables.transform((Iterable)iterable, (Function)new DeltaToAbstractDeployedTransformer());
        Iterable iterable5 = Iterables.transform((Iterable)iterable2, (Function)new DeltaToAbstractDeployedTransformer(true));
        Iterable iterable6 = Iterables.transform((Iterable)iterable3, (Function)new DeltaToAbstractDeployedTransformer());
        return Iterables.concat((Iterable)iterable4, (Iterable)iterable5, (Iterable)iterable6);
    }

    public static boolean isSubtypeOf(Type type, Type type2) {
        return type2.instanceOf(type);
    }

    public static Iterable<ContextElement<?>> extractDeployedContextElements(Iterable<AbstractDeployed<?>> iterable) {
        return Iterables.transform((Iterable)Iterables.filter(iterable, (Predicate)new Predicate<AbstractDeployed<?>>(){

            public boolean apply(AbstractDeployed<?> abstractDeployed) {
                return abstractDeployed.getType().instanceOf(CONTEXT_ELEMENT_TYPE);
            }
        }), (Function)new Function<AbstractDeployed<?>, ContextElement<?>>(){

            public ContextElement<?> apply(AbstractDeployed<?> abstractDeployed) {
                return (ContextElement)abstractDeployed;
            }
        });
    }

    private static class DeltaToAbstractDeployedTransformer
    implements Function<Delta, AbstractDeployed<?>> {
        private boolean transformPreviousDeployedForModifyOp;

        DeltaToAbstractDeployedTransformer() {
        }

        DeltaToAbstractDeployedTransformer(boolean bl) {
            this.transformPreviousDeployedForModifyOp = bl;
        }

        public AbstractDeployed<?> apply(Delta delta) {
            Deployed deployed = delta.getDeployed();
            if (delta.getOperation() == Operation.MODIFY) {
                if (this.transformPreviousDeployedForModifyOp) {
                    deployed = delta.getPrevious();
                }
            } else if (delta.getOperation() == Operation.DESTROY) {
                deployed = delta.getPrevious();
            }
            return (AbstractDeployed)deployed;
        }
    }

    private static class DeltasTargetedToContainerFilter
    implements Predicate<Delta> {
        private Type type;
        private boolean modifyOpsMode;
        private boolean filterPreviousDeployed;

        DeltasTargetedToContainerFilter(Type type) {
            this.type = type;
        }

        DeltasTargetedToContainerFilter(Type type, boolean bl, boolean bl2) {
            this.type = type;
            this.modifyOpsMode = bl;
            this.filterPreviousDeployed = bl2;
        }

        static DeltasTargetedToContainerFilter filterAllOperationsBesidesModifyOps(Type type) {
            return new DeltasTargetedToContainerFilter(type);
        }

        static DeltasTargetedToContainerFilter filterOnlyModifyOpsAndPreviousDeployed(Type type) {
            return new DeltasTargetedToContainerFilter(type, true, true);
        }

        static DeltasTargetedToContainerFilter filterOnlyModifyOpsAndCurrentDeployed(Type type) {
            return new DeltasTargetedToContainerFilter(type, true, false);
        }

        public boolean apply(Delta delta) {
            if (delta.getOperation() == Operation.MODIFY) {
                if (!this.modifyOpsMode) {
                    return false;
                }
                Deployed deployed = this.filterPreviousDeployed ? delta.getPrevious() : delta.getDeployed();
                return this.accept(deployed, this.type);
            }
            return this.accept(delta.getPrevious(), this.type) || this.accept(delta.getDeployed(), this.type);
        }

        private boolean accept(Deployed<?, ?> deployed, Type type) {
            return deployed != null && deployed.getContainer().getType().instanceOf(type) && deployed instanceof AbstractDeployed;
        }
    }
}

