/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.processor;

import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextElement;
import com.xebialabs.deployit.plugin.tomcat.processor.Utils;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonContextNameInjector {
    public static final Type COMMON_CONTEXT_TYPE = Type.valueOf((String)"tomcat.CommonContext");
    private static final Logger logger = LoggerFactory.getLogger(CommonContextNameInjector.class);

    @PrePlanProcessor
    public List<DeploymentStep> injectContextNameInToContextElements(DeltaSpecification deltaSpecification) {
        Iterable<AbstractDeployed<?>> iterable = this.findDeployedsTargetedToCommonContexts(deltaSpecification.getDeltas());
        logger.debug("Found {} deployeds targeted to common context", (Object)Iterables.size(iterable));
        this.injectCommonContextNameIntoContextElements(iterable);
        return Collections.emptyList();
    }

    protected void injectCommonContextNameIntoContextElements(Iterable<AbstractDeployed<?>> iterable) {
        Iterable<ContextElement<?>> iterable2 = this.extractContextElements(iterable);
        logger.debug("Found {} context elements targeted to common context", (Object)Iterables.size(iterable2));
        for (ContextElement<?> contextElement : iterable2) {
            contextElement.setContext("context");
        }
    }

    protected Iterable<ContextElement<?>> extractContextElements(Iterable<AbstractDeployed<?>> iterable) {
        return Utils.extractDeployedContextElements(iterable);
    }

    protected Iterable<AbstractDeployed<?>> findDeployedsTargetedToCommonContexts(List<Delta> list) {
        return Utils.findDeployedsTargetedToContainer(list, COMMON_CONTEXT_TYPE);
    }
}

