/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.deployed;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.ProcessedTemplate;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

@Metadata(virtual=true, description="Base type for all Tomcat resources")
public class ContextElement<D extends Deployable>
extends ProcessedTemplate<D> {
    @Property(required=false, description="The name of the context that this resource is associated with")
    private String context;
    private boolean destroyOperation;
    private boolean createOperation;

    public void executeCreate(DeploymentPlanningContext deploymentPlanningContext) {
        this.createOperation = true;
        super.executeCreate(deploymentPlanningContext);
    }

    public void executeModify(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        ContextElement contextElement = (ContextElement)delta.getPrevious();
        contextElement.executeDestroy(deploymentPlanningContext);
        this.executeCreate(deploymentPlanningContext);
    }

    public void executeDestroy(DeploymentPlanningContext deploymentPlanningContext) {
        this.destroyOperation = true;
        TemplateArtifactCopyStep templateArtifactCopyStep = this.createTemplateArtifactCopyStep();
        templateArtifactCopyStep.setDescription(this.getDescription(this.getDestroyVerb()));
        deploymentPlanningContext.addStep((DeploymentStep)templateArtifactCopyStep);
    }

    public String getDescription(String string) {
        return String.format("%s %s in %s.xml on %s", string, this.getName(), this.getContext(), ((HostContainer)this.getContainer()).getName());
    }

    public String getContext() {
        return this.resolveExpression(this.context);
    }

    public void setContext(String string) {
        this.context = string;
    }

    public boolean isDestroyOperation() {
        return this.destroyOperation;
    }

    public void setDestroyOperation(boolean bl) {
        this.destroyOperation = bl;
    }

    public boolean isCreateOperation() {
        return this.createOperation;
    }

    public void setCreateOperation(boolean bl) {
        this.createOperation = bl;
    }
}

