package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.plugin.generic.step.GenericBaseStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Strings.emptyToNull;

public class RenameFileStep extends GenericBaseStep {

    private String source;
    private String target;

    public RenameFileStep(int order, String source, String target, String description, HostContainer container) {
        super(order, description, container);
        checkNotNull(emptyToNull(source));
        checkNotNull(emptyToNull(target));
        this.source = source;
        this.target = target;
    }

    @Override
    protected Result doExecute() throws Exception {
        OverthereFile sourceFile = getRemoteConnection().getFile(source);
        OverthereFile targetFile = getRemoteConnection().getFile(target);
        if (targetFile.exists()) {
            getCtx().logError("Source file "+ source +" cannot be renamed to "+ target +", because file already exists.");
            return Result.Fail;
        }

        getCtx().logOutput("Copying file " + source +" to "+ target +".");
        sourceFile.copyTo(targetFile);
        getCtx().logOutput("Removing file " + source);
        sourceFile.deleteRecursively();
        return Result.Success;

    }
}
