<#--

    Copyright (c) 2018. All rights reserved.

    This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

-->
#!/bin/bash
<#assign envVars=container.envVars />
<#list envVars?keys as envVar>
${envVar}="${envVars[envVar]}"
export ${envVar}
</#list>
cd "${container.home}"

check_status() {
    if [ "$match1" -gt 0 ] ; then
        status=RUNNING
    elif [ $? -eq 1 ] ; then
        status=STOPPED
    elif [ $? -gt 1 ] ; then
        status=STOPPED
        echo "Incorrect command. , Exit Code Returned  $?"
        exit 1
    else
        echo "Could Not Determine Status."
        status=STOPPED
    fi
    echo "Server is currently $status"
}


echo 'Starting Server...'
<#if container.startCommand?? && (container.statusCommandExpectedOutput)??>
match1=$(${container.statusCommand} | grep -c "${container.statusCommandExpectedOutput}")
check_status
if [ "$status" != "RUNNING" ] ; then
    ${container.startCommand}
    sleep ${container.serverStartupTime}s
    match1=$(${container.statusCommand} | grep -c "${container.statusCommandExpectedOutput}")
    check_status
    if [ "$status" != "RUNNING" ] ; then
        echo "Could not Start Server"
        exit 1
    else
        echo "Server Started Successfully"
    fi
else
    echo "Server is already running, nothing to do"
fi
<#else>
    echo "Tomcat running status is not checked. To check, set status command and expected status command output to match"
    echo "Executing start command"
    ${container.startCommand}
    exit 0
</#if>



