/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.ProcessedTemplate;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

@Metadata(virtual=true, description="Base type for all Tomcat resources")
public class ContextElement<D extends Deployable>
extends ProcessedTemplate<D> {
    @Property(required=false, description="The name of the context that this resource is associated with")
    private String context;
    private boolean destroyOperation;
    private boolean createOperation;

    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        this.createOperation = true;
        super.executeCreate(ctx, delta);
    }

    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        ContextElement previous = (ContextElement)delta.getPrevious();
        previous.executeDestroy(ctx, delta);
        this.executeCreate(ctx, delta);
    }

    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        this.destroyOperation = true;
        TemplateArtifactCopyStep step = this.createTemplateArtifactCopyStep(delta.getPrevious());
        step.setDescription(this.getDescription(this.getDestroyVerb()));
        ctx.addStepWithCheckpoint((Step)new ContextElementDestroyStep(this.getDestroyOrder(), (Step)step), delta, Operation.DESTROY);
    }

    public String getDescription(String verb) {
        return String.format("%s %s in %s.xml on %s", verb, this.getName(), this.getContext(), ((HostContainer)this.getContainer()).getName());
    }

    public String getContext() {
        return this.resolveExpression(this.context);
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isDestroyOperation() {
        return this.destroyOperation;
    }

    public void setDestroyOperation(boolean destroyOperation) {
        this.destroyOperation = destroyOperation;
    }

    public boolean isCreateOperation() {
        return this.createOperation;
    }

    public void setCreateOperation(boolean createOperation) {
        this.createOperation = createOperation;
    }

    private static class ContextElementDestroyStep
    implements Step {
        private int order;
        private Step delegate;

        ContextElementDestroyStep(int order, Step delegate) {
            this.order = order;
            this.delegate = delegate;
        }

        public int getOrder() {
            return this.order;
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public StepExitCode execute(ExecutionContext ctx) throws Exception {
            return this.delegate.execute(ctx);
        }
    }
}

